<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

$vendorPerRow = 3;
$cellClass    = 'col-sm-' . floor(12/$vendorPerRow);
?>
<section class="vendor-default-view">
	<?php if(!empty($this->vendors)) : ?>
		<div class="row row-condensed">
			<?php foreach($this->vendors as $vendor) : ?>
				<?php $url = JRoute::_('index.php?option=com_virtuemart&view=vendor&virtuemart_vendor_id=' . $vendor->virtuemart_vendor_id, false);	?>
				<div class="<?php echo $cellClass ?>">
					<div class="vendor">
						<div class="vendor-inner">
							<div class="vendor-storename-cont">
								<h2 class="vendor-storename">
									<a href="<?php echo $url; ?>" class="hover-invert" title="<?php echo $vendor->vendor_store_name; ?>"><?php echo $vendor->vendor_store_name; ?></a>
								</h2>
							</div>
							<div class="vendor-name-cont">
								<span><?php echo $vendor->vendor_name; ?></span>
							</div>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php else : ?>
		<p class="bg-box bg-danger">Some serious configuration problem, no vendor found.</p>
	<?php endif; ?>
</section>