<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

if (!version_compare(JVERSION, '4.0.0', 'ge')) : ?>
	<?php
	/**
	 * Layout variables
	 * ---------------------
	 * 	$options         : (array)  Optional parameters
	 * 	$label           : (string) The html code for the label (not required if $options['hiddenLabel'] is true)
	 * 	$input           : (string) The input field html code
	 */
	if (!empty($displayData['options']['showonEnabled']))
	{
		JHtml::_('jquery.framework');
		JHtml::_('script', 'jui/cms.js', false, true);
	}

	$global = VPFrameworkGlobal::getInstance();
	$format = $global->getState('form.renderfields.format', null);
	$fieldClass = isset($format['fieldClass']) ? $format['fieldClass'] : '';

	$class = empty($displayData['options']['class']) ? "" : " " . $displayData['options']['class'];
	$rel   = empty($displayData['options']['rel']) ? "" : " " .  $displayData['options']['rel'];
	?>
	<?php if(!empty($format)) : ?>
		<div class="form-group<?php echo $class; ?>"<?php echo $rel; ?>>
			<?php if (empty($displayData['options']['hiddenLabel'])) : ?>
				<?php echo $displayData['label']; ?>
			<?php endif; ?>
			<div class="<?php echo $fieldClass ?>"><?php echo $displayData['input']; ?></div>
		</div>
	<?php else : ?>
		<div class="control-group<?php echo $class; ?>"<?php echo $rel; ?>>
			<?php if (empty($displayData['options']['hiddenLabel'])) : ?>
				<div class="control-label"><?php echo $displayData['label']; ?></div>
			<?php endif; ?>
			<div class="controls"><?php echo $displayData['input']; ?></div>
		</div>
	<?php endif; ?>
<?php else : ?>
	<?php
	extract($displayData);
	
	/**
	 * Layout variables
	 * -----------------
	 * @var   array   $options      Optional parameters
	 * @var   string  $name         The id of the input this label is for
	 * @var   string  $label        The html code for the label
	 * @var   string  $input        The input field html code
	 * @var   string  $description  An optional description to use in a tooltip
	 */

	if (!empty($options['showonEnabled']))
	{
		/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
		$wa = JFactory::getApplication()->getDocument()->getWebAssetManager();
		$wa->useScript('showon');
	}

	$class           = empty($options['class']) ? '' : ' ' . $options['class'];
	$rel             = empty($options['rel']) ? '' : ' ' . $options['rel'];
	$id              = $name . '-desc';
	$hideLabel       = !empty($options['hiddenLabel']);
	$hideDescription = empty($options['hiddenDescription']) ? false : $options['hiddenDescription'];

	if (!empty($parentclass))
	{
		$class .= ' ' . $parentclass;
	}

	?>
	<div class="control-group<?php echo $class; ?>"<?php echo $rel; ?>>
		<?php if ($hideLabel) : ?>
			<div class="visually-hidden"><?php echo $label; ?></div>
		<?php else : ?>
			<div class="control-label"><?php echo $label; ?></div>
		<?php endif; ?>
		<div class="controls">
			<?php echo $input; ?>
			<?php if (!$hideDescription && !empty($description)) : ?>
				<div id="<?php echo $id; ?>">
					<small class="form-text">
						<?php echo $description; ?>
					</small>
				</div>
			<?php endif; ?>
		</div>
	</div>
<?php endif; ?>
