<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$msgList = $displayData['msgList'];
$classMap = array('message' => 'warning', 'error' => 'danger', 'notice' => 'info');
?>
<div id="system-message-container">
	<?php if (is_array($msgList) && !empty($msgList)) : ?>
		<div id="system-message">
			<?php foreach ($msgList as $type => $msgs) : ?>
				<?php
				$type = trim($type);
				$type = !empty($type) ? strtolower($type) : 'warning';
				$class = array_key_exists($type, $classMap) ? $classMap[$type] : $type; 
				?>
				<div class="alert alert-<?php echo $class; ?> alert-dismissible" role="alert">
					<button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"><?php echo JText::_('JLIB_HTML_BEHAVIOR_CLOSE') ?></span></button>
					<?php if (!empty($msgs)) : ?>
						<h4 class="sr-only"><?php echo JText::_($type); ?></h4>
						<?php foreach ($msgs as $key => $msg) : ?>
							<p class="msg-number-<?php echo ($key + 1) ?>"><?php echo $msg; ?></p>
						<?php endforeach; ?>
					<?php endif; ?>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>
