<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$template        = plgSystemVPFrameworkHelper::getTemplate();
$globalHelper    = VPFrameworkGlobal::getInstance();
$previousItem    = $globalHelper->getState('previous_item', null);
$nextItem        = $globalHelper->getState('next_item', null);
$hasNav          = (!empty($previousItem) && is_array($previousItem)) || (!empty($nextItem) && is_array($nextItem));
$moduleclass_sfx = $params->get('moduleclass_sfx', '');

// Get rid of duplicated entries on trail including home page when using multilanguage
for ($i = 0; $i < $count; $i++)
{
	if ($i == 1 && !empty($list[$i]->link) && !empty($list[$i - 1]->link) && $list[$i]->link == $list[$i - 1]->link)
	{
		unset($list[$i]);
	}
}

// Find last and penultimate items in breadcrumbs list
end($list);
$last_item_key = key($list);
prev($list);
$penult_item_key = key($list);

// Make a link if not the last item in the breadcrumbs
$show_last = $params->get('showLast', 1);
?>
<div class="breadcrumbs-inner<?php echo $hasNav ? ' has-nav' : ''; ?>">
	<?php if($template->params->get('pagetitle_in_breadcrumbs', 1))
	{
		$title     = isset($list[$last_item_key]) ? (string) $list[$last_item_key]->name : '';
		$title     = $template->getPageHeading($title);

		if(!empty($title))
		{
			echo '<h1>' . $title . '</h1>';
		}
	}
	?>
	<ul class="breadcrumb<?php echo $moduleclass_sfx . ($params->get('showHere', 1) ? ' has-here' : '') ?>">
		<?php
		if($params->get('showHere', 1))
		{
			echo '<li class="active text-muted">' . JText::_('MOD_BREADCRUMBS_HERE') . '&#160;</li>';
		}
		
		// Generate the trail
		foreach ($list as $key => $item)
		{
			if ($key != $last_item_key)
			{
				// Render all but last item - along with separator
				echo '<li>';
				if (!empty($item->link))
				{
					echo '<a class="hover-invert" href="' . $item->link . '">' . $item->name . '</a>';
				}
				else
				{
					echo $item->name;
				}

				echo '</li>';
			}
			elseif ($show_last)
			{
				// Render last item if reqd.
				echo '<li class="active">';
				echo $item->name;
				echo '</li>';
			}
		} ?>
	</ul>
	<?php if ($hasNav) : ?>
		<div class="breadcrumb-navigations clearfix">
			<?php if (!empty($previousItem) && is_array($previousItem)) : ?>
				<a href="<?php echo $previousItem['url'] ?>" title="<?php echo htmlspecialchars($previousItem['text'], ENT_QUOTES, 'UTF-8'); ?>" class="previous-nav hasTooltip" data-placement="right">
					<i class="fa fa-angle-left"></i><span class="sr-only"><?php echo $previousItem['text'] ?></span></a>
			<?php endif; ?>
			<?php if (!empty($nextItem) && is_array($nextItem)) : ?>
				<a href="<?php echo $nextItem['url'] ?>" title="<?php echo htmlspecialchars($nextItem['text'], ENT_QUOTES, 'UTF-8'); ?>" class="next-nav hasTooltip" data-placement="left">
					<i class="fa fa-angle-right"></i><span class="sr-only"><?php echo $nextItem['text'] ?></span></a>
			<?php endif; ?>
		</div>
	<?php endif; ?>
</div>
