<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

if (!empty($attribs['name']))
{
	if (!empty($class_sfx))
	{
		$class_sfx = trim(str_replace(PHP_EOL, ' ', $class_sfx));
		
		if (strpos($class_sfx, ' ') !== false)
		{
			$class_sfx = explode(' ', $class_sfx);
		}
		else
		{
			$class_sfx = (array) $class_sfx;
		}
	}
	else
	{
		$class_sfx = array();
	}
	
	if ($attribs['name'] == 'fee-menu')
	{
		$class_sfx[] = 'nav';
	}
	elseif (in_array($attribs['name'], array('footer-left', 'footer-right')))
	{
		$class_sfx[] = 'inline';
	}
	
	if (!empty($class_sfx))
	{
		$class_sfx = array_filter(array_unique($class_sfx));
		$class_sfx = !empty($class_sfx) ? ' ' . implode(' ', $class_sfx) : '';
	}
}
// Note. It is important to remove spaces between elements.
?>
<?php // The menu class is deprecated. Use nav instead. ?>
<ul class="menu<?php echo $class_sfx;?>"<?php
	$tag = '';

	if ($params->get('tag_id') != null)
	{
		$tag = $params->get('tag_id') . '';
		echo ' id="' . $tag . '"';
	}
?>>
<?php
foreach ($list as $i => &$item)
{
	$class      = 'item-' . $item->id;
	$itemParams = version_compare(JVERSION, '4.0.0', 'ge') ? $item->getParams() : $item->params;

	if (($item->id == $active_id) OR ($item->type == 'alias' AND $itemParams->get('aliasoptions') == $active_id))
	{
		$class .= ' current';
	}

	if (in_array($item->id, $path))
	{
		$class .= ' active';
	}
	elseif ($item->type == 'alias')
	{
		$aliasToId = $itemParams->get('aliasoptions');

		if (count($path) > 0 && $aliasToId == $path[count($path) - 1])
		{
			$class .= ' active';
		}
		elseif (in_array($aliasToId, $path))
		{
			$class .= ' alias-parent-active';
		}
	}

	if ($item->type == 'separator')
	{
		$class .= ' divider';
	}

	if ($item->deeper)
	{
		$class .= ' deeper';
	}

	if ($item->parent)
	{
		$class .= ' parent';
	}

	if (!empty($class))
	{
		$class = ' class="' . trim($class) . '"';
	}

	echo '<li' . $class . '>';

	// Render the menu item.
	switch ($item->type) :
		case 'separator':
		case 'url':
		case 'component':
		case 'heading':
			require JModuleHelper::getLayoutPath('mod_menu', 'default_' . $item->type);
			break;

		default:
			require JModuleHelper::getLayoutPath('mod_menu', 'default_url');
			break;
	endswitch;

	// The next item is deeper.
	if ($item->deeper)
	{
		echo '<ul class="nav-child unstyled small">';
	}
	elseif ($item->shallower)
	{
		// The next item is shallower.
		echo '</li>';
		echo str_repeat('</ul></li>', $item->level_diff);
	}
	else
	{
		// The next item is on the same level.
		echo '</li>';
	}
}
?></ul>
