<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

// Note. It is important to remove spaces between elements.
$title      = $item->anchor_title ? ' title="' . $item->anchor_title . '" ' : '';
$class      = $item->anchor_css ? ' ' . $item->anchor_css : '';
$itemParams = version_compare(JVERSION, '4.0.0', 'ge') ? $item->getParams() : $item->params;

if (!empty($item->menu_icon))
{
	// The link is an icon
	if ($itemParams->get('menu_text', 1))
	{
		// If the link text is to be displayed, the icon is added with aria-hidden
		$linktype = '<span class="p-2 ' . $item->menu_icon . '" aria-hidden="true"></span>' . $item->title;
	}
	else
	{
		// If the icon itself is the link, it needs a visually hidden text
		$linktype = '<span class="p-2 ' . $item->menu_icon . '" aria-hidden="true"></span><span class="visually-hidden">' . $item->title . '</span>';
	}
}
elseif ($item->menu_image)
{
	$itemParams->get('menu_text', 1) ?
	$linktype = '<img' . (!empty($item->menu_image_css) ? ' class="' . $item->menu_image_css . '"' : '') . ' src="' . $item->menu_image . '" alt="' . $item->title . '" /><span class="image-title">' . $item->title . '</span> ' :
	$linktype = '<img' . (!empty($item->menu_image_css) ? ' class="' . $item->menu_image_css . '"' : '') . ' src="' . $item->menu_image . '" alt="' . $item->title . '" />';
}
else
{
	$linktype = $item->title;
}
if($item->deeper)
{
	$linktype .= '<span class="opener"></span>';
}
?>
<span class="separator<?php echo $class; ?>"<?php echo $title; ?>>
	<?php echo $linktype; ?>
</span>
