<?php
/**
 * @package    VirtueMart Essentials
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;
?>
<div class="vme-mod-compare <?php echo $class_sfx ?>">
	<div class="vmessentials-wrapper vme-mod-container">
		<div class="vme-mod-inner">
			<div class="vp-dropmod-container vme-mod-contents">
				<div class="vp-dropmod-anchor btn-jewel-group">
					<a href="<?php echo !empty($url) ? $url : '#'; ?>" class="color-base <?php echo empty($count) ? 'empty' : 'has-item'; ?>"><i class="fa fa-copy fa-2x"></i></a>
					<?php if(!empty($count)) : ?>
						<div class="jewel jewel-top jewel-invert">
							<span class="product-count"><?php echo (int) $count ?></span>
						</div>
					<?php endif; ?>
				</div>
				<div class="vp-dropmod-inner">
					<div class="vp-dropmod-contents">
						<?php if(empty($count)) : ?>
							<div class="vp-dropmod-header empty">
								<div class="row row-mini">
									<div class="col-xs-12 align-center">
										<?php echo JText::_('MOD_VME_COMPARE_EMPTY_COMPARE') ?>
									</div>
								</div>
							</div>
						<?php else : ?>
							<div class="vp-dropmod-header">
								<div class="row row-mini">
									<div class="col-xs-12">
										<span class="product-count-text"><?php echo JText::plural('MOD_VME_COMPARE_N_PRODUCTS', $count); ?></span>
										<?php if(!empty($url)) : ?>
											<a class="btn btn-sm btn-base pull-right" href="<?php echo $url ?>" title="<?php echo JText::_('MOD_VME_COMPARE_COMPARE') ?>"><?php echo JText::_('MOD_VME_COMPARE_COMPARE') ?></a>
										<?php endif; ?>
									</div>
								</div>
							</div>
							<?php foreach($products as $key => $product) : ?>
								<div class="row row-mini product-row">
									<div class="col-xs-3">
										<a href="<?php echo $product->link ?>" class="product-thumbnail">
											<?php echo !empty($product->images[0]) ? $product->images[0]->displayMediaThumb('', false) : ''; ?>
										</a>
									</div>
									<div class="col-xs-8">
										<?php echo JHtml::link ($product->link, $product->product_name, 'class="mod-product-name hover-invert"'); ?>
										<?php if($params->get('show_price', 1) && $currency->_priceConfig['salesPrice'][0]) : ?>
										<div class="mod-product-price">
											<?php echo $currency->priceDisplay($product->prices['salesPrice']); ?>
										</div>
										<?php endif; ?>
									</div>
									<div class="col-xs-1">
										<form action="<?php echo JRoute::_('index.php?option=com_vmessentials&view=compare') ?>" method="post" class="vmessentials-form">
											<button type="submit" class="close remove vme-remove-btn" title="<?php echo JText::_('MOD_VME_COMPARE_REMOVE') ?>"<?php echo $use_ajax ? ' data-vmecompareremove' : ''; ?>>
												<span aria-hidden="true">&times;</span><span class="vme-sr-only"><?php echo JText::_('MOD_VME_COMPARE_REMOVE') ?></span>
											</button>
											<input type="hidden" name="option" value="com_vmessentials" />
											<input type="hidden" name="task" value="compare.remove" />
											<input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
											<input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
											<?php echo JHtml::_('form.token'); ?>
											<?php echo JHtml::_('vmessentials.returnUri'); ?>
										</form>
									</div>
								</div>
								<?php if(($key + 1) != $count) : ?>
									<div class="mod-row-separator"></div>
								<?php endif; ?>
							<?php endforeach; ?>
						<?php endif; ?>
						<div class="vme-mod-loader vme-hide" aria-hidden="true"></div>
						<div class="vme-mod-loader-wheel vme-hide" aria-hidden="true"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>