<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$vpframework     = false;
$listMode        = '';
$customClass     = 'product-cart-variants hide';
$stockhandle     = VmConfig::get('stockhandle', 'none');
$costPrice       = (float) $product->prices['costPrice'];
$salesPrice      = (float) $product->prices['salesPrice'];
$tmpPrice        = !empty($costPrice) && !empty($salesPrice);
$step            = isset($product->step_order_level) ? $product->step_order_level : 1;
$step            = (empty($step)) ? 1 : $step;
$btn_lg          = 'btn-md';
$addtoCartButton = '';
$noAddToCart     = ($product->product_discontinued && $params->get('vm_handle_discontinued_products', 0)) ? true : false;

if (!VmConfig::get('use_as_catalog', 0))
{
	if (isset($product->addToCartButton) && !empty($product->addToCartButton))
	{
		$addtoCartButton = $product->addToCartButton;
	} 
	else 
	{
		$addtoCartButton = shopFunctionsF::getAddToCartButton($product->orderable);
	}
	
	if (strpos($addtoCartButton, 'class=') !== false)
	{
		$addtoCartButton = str_replace('class="', 'class="btn btn-invert btn-addtocart ' . $btn_lg . ' ', $addtoCartButton);
	}
	else
	{
		$addtoCartButton = str_replace('type=', 'class="btn btn-invert btn-addtocart ' . $btn_lg . '" type=', $addtoCartButton);
	}
}
?>
<div class="addtocart-area">
	<form method="post" class="product js-recalculate" action="<?php echo JRoute::_('index.php', false); ?>">
		
		<?php if (!VmConfig::get('use_as_catalog', 0)) : ?>
			<div class="addtocart-bar clearfix is-list">
			
				<?php if (VPFrameworkVM::hasCartAttribute($product)) : ?>
					<a href="<?php echo $product->link; ?>" title="<?php echo JText::_('TPL_VP_SMART_VIEW_OPTIONS') ?>" class="btn btn-invert btn-addtocart btn-options <?php echo $btn_lg ?>"><?php echo JText::_('TPL_VP_SMART_VIEW_OPTIONS') ?></a>
				<?php elseif ((property_exists($product, 'show_notify') && $product->show_notify) || (($stockhandle == 'disableit' || $stockhandle == 'disableadd') && ($product->product_in_stock - $product->product_ordered) < 1)) : ?>
					<a href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&layout=notify&virtuemart_product_id=' . $product->virtuemart_product_id); ?>" class="btn btn-info btn-notify <?php echo $btn_lg ?>" target="_top"><?php echo vmText::_ ('COM_VIRTUEMART_CART_NOTIFY') ?></a>
				<?php else : ?>
					<?php if (!(VmConfig::get('askprice', true) && empty($tmpPrice)) && $product->orderable && !$noAddToCart) : ?>
						<?php
						if (isset($product->step_order_level) && (int)$product->step_order_level > 0)
						{
							$value = $product->step_order_level;
						}
						elseif (!empty($product->min_order_level))
						{
							$value = $product->min_order_level;
						}
						else
						{
							$value = 1;
						}
						
						$maxOrder = '';
						
						if (!empty($product->max_order_level))
						{
							$maxOrder = ' max="'.$product->max_order_level.'" ';
						}
						
						$hideClass = !empty($show_qty_selector) ? '' : ' hide';
						?>
						<span class="quantity-box-cont quantity-box<?php echo $hideClass ?>">
							<input type="text" class="form-control input-lg quantity-input js-recalculate" name="quantity[]" data-errStr="<?php echo vmText::_('COM_VIRTUEMART_WRONG_AMOUNT_ADDED')?>" value="<?php echo $value; ?>" init="<?php echo $value; ?>" step="<?php echo $step; ?>"<?php echo $maxOrder; ?> />
							<span class="quantity-controls-cont">
								<button type="button" class="quantity-controls quantity-plus"><i class="fa fa-angle-up"></i></button>
								<button type="button" class="quantity-controls quantity-minus"><i class="fa fa-angle-down"></i></button>
							</span>
						</span>
					<?php endif; ?>
					
					<?php if ($noAddToCart) : ?>
						<div class="text-danger"><strong><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_PRODUCT_DISCONTINUED') ?></strong></div>
					<?php elseif (!(VmConfig::get('askprice', true) && empty($tmpPrice)) && !empty($addtoCartButton)) : ?>
						<span class="addtocart-button-cont">
							<?php echo $addtoCartButton; ?>
						</span>
						<noscript><input type="hidden" name="task" value="add"/></noscript>
					<?php endif; ?>
					
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<input type="hidden" name="option" value="com_virtuemart"/>
		<input type="hidden" name="view" value="cart"/>
		<input type="hidden" name="virtuemart_product_id[]" value="<?php echo $product->virtuemart_product_id ?>"/>
		<input type="hidden" class="pname" value="<?php echo $product->product_name ?>"/>
		<?php if ($itemId = $input->getInt('Itemid', 0)) : ?>
			<input type="hidden" name="Itemid" value="<?php echo $itemId ?>"/>
		<?php endif; ?>
	</form>
</div>