<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined ('_JEXEC') or die('Restricted access');

$priceType = $params->get('displayed_price_type', 'salesPrice');
$priceDesc = $priceType == 'unitPrice' ?
             vmText::sprintf ('COM_VIRTUEMART_PRODUCT_UNITPRICE', vmText::_('COM_VIRTUEMART_UNIT_SYMBOL_'.$product->product_unit)) :
             '';
$discount  = !empty($product->prices['discountAmount']) ? round($product->prices['discountAmount'], $currency->_priceConfig['salesPrice'][1]) : 0;
?>
<?php if(!$product->product_discontinued || $template_params->get('vm_handle_discontinued_products', 0) < 2) : ?>
	<div class="product-price" id="productPrice<?php echo $product->virtuemart_product_id ?>">
		<?php if($product->prices['salesPrice'] <= 0 && VmConfig::get ('askprice', 1) && isset($product->images[0]) && !$product->images[0]->file_is_downloadable) : ?>
			<?php $url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id . '&tmpl=component', false); ?>
			<button type="button" class="btn btn-primary btn-md" data-iframe="modal" data-modaltitle="<?php echo vmText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?>" title="<?php echo vmText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?>" data-url="<?php echo $url ?>">
				<span><?php echo vmText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?></span>
			</button>
		<?php else : ?>
			<?php if($priceType != 'basePriceWithTax' && $priceType != 'salesPriceWithDiscount') : ?>
				<?php if(!empty($discount) && VmConfig::get('basePriceWithTax', 0) && !empty($product->prices['basePriceWithTax']) && round($product->prices['basePriceWithTax'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
					<div class="product-price-before-discount">
						<?php echo $currency->createPriceDiv ('basePriceWithTax', '', $product->prices) ?>
					</div>
				<?php elseif(!empty($discount) && VmConfig::get('salesPriceWithDiscount', 0) && !empty($product->prices['salesPriceWithDiscount']) && round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
					<div class="product-price-before-discount">
						<?php echo $currency->createPriceDiv ('salesPriceWithDiscount', '', $product->prices) ?>
					</div>
				<?php endif; ?>
			<?php elseif(!empty($discount) && $priceType == 'basePriceWithTax' && VmConfig::get('salesPriceWithDiscount', 0) && !empty($product->prices['salesPriceWithDiscount']) && round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
				<div class="product-price-before-discount">
					<?php echo $currency->createPriceDiv ('salesPriceWithDiscount', '', $product->prices) ?>
				</div>
			<?php endif; ?>
			<div class="product-sales-price">
				<?php echo $currency->createPriceDiv($priceType, $priceDesc, $product->prices); ?>
			</div>
			<?php
			$infotax = vmConfig::get('vm_prices_info_tax', 0);
			$infodelivery = vmConfig::get('vm_prices_info_delivery', 0);
			if (($infotax || $infodelivery) && !empty($product->prices['salesPrice'])) : ?>
				<div class="vm-prices-info text-muted text-small small text-center">
					<?php if ($infotax)
					{
						if($product->prices['priceWithoutTax'] == $product->prices['salesPrice'])
						{
							$taxclusive = 'COM_VM_TAX_EXCLUSIVE';
						}
						else
						{
							$taxclusive = 'COM_VM_TAX_INCLUSIVE';
						}
						
						echo vmText::_($taxclusive);
					}
					
					if($infotax && $infodelivery)
					{
						echo vmText::_('COM_VM_PRICES_INFO_DIVIDER');
					}
					
					if($infodelivery)
					{
						echo vmText::_('COM_VM_PRICES_INFO_DELIVERY');
					} ?>
				</div>
			<?php endif; ?>
			<?php if($priceType != 'discountAmount' && VmConfig::get('discountAmount', 0) && !empty($discount)) : ?>
				<div class="product-discount-amount">
					<?php $discount = ($product->prices['discountAmount'] < 0) ? ($product->prices['discountAmount'] * -1) : $product->prices['discountAmount']; ?>
					<span class="text-danger"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_YOU_SAVE') . ': ' . $currency->priceDisplay($discount); ?></span>
				</div>
			<?php endif; ?>
		<?php endif; ?>
	</div>
<?php endif; ?>