<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$class         = $item->anchor_css ? 'class="separator nav-header ' . $item->anchor_css . '" ' : 'class="separator nav-header"';
$title         = $item->anchor_title ? ' title="' . $item->anchor_title . '" ' : '';
$itemParams    = method_exists($item, 'getParams') ? $item->getParams() : $item->params;
$description   = trim($itemParams->get('mega_desc', ''));
$sticker       = trim($itemParams->get('mega_sticky_text', ''));
$sticker_style = $itemParams->get('mega_sticky_style', 'grey');
$sticker       = !empty($sticker) ? '<span class="sticker sticker-' . $sticker_style . '">' . $sticker . '</span>' : '';
$icon          = $itemParams->get('mega_icon_class', '');

if ($icon)
{
	if ($itemParams->get('menu_text', 1))
	{
		if ($itemParams->get('mega_showdesc', 1) && !empty($description))
		{
			$linktype = '<span class="menu-group with-icon with-description"><span class="menu-image"><i class="' . $icon . '"></i></span><span class="image-title">' . $item->title . '</span>' . $sticker . '<span class="menu-desc">' . $description . '</span></span>';
		}
		else
		{
			$linktype = '<span class="menu-group with-icon"><span class="menu-image"><i class="' . $icon . '"></i></span><span class="image-title">' . $item->title . '</span>' . $sticker . '</span>';
		}
	}
	else
	{
		$linktype = '<span class="menu-group"><span class="menu-image"><i class="' . $icon . '"></i></span>' . $sticker . '</span>';
	}
}
elseif ($item->menu_image)
{
	if ($itemParams->get('menu_text', 1))
	{
		if ($itemParams->get('mega_showdesc', 1) && !empty($description))
		{
			$linktype = '<span class="menu-group with-image with-description"><span class="menu-image"><img src="' . $item->menu_image . '" alt="' . $item->title . '" /></span><span class="image-title">' . $item->title . '</span>' . $sticker . '<span class="menu-desc">' . $description . '</span></span>';
		}
		else
		{
			$linktype = '<span class="menu-group width-image"><span class="menu-image"><img src="' . $item->menu_image . '" alt="' . $item->title . '" /></span><span class="image-title">' . $item->title . '</span>' . $sticker . '</span>';
		}
	}
	else
	{
		$linktype = '<span class="menu-group"><span class="menu-image"><img src="' . $item->menu_image . '" alt="' . $item->title . '" /></span>' . $sticker . '</span>';
	}
}
else
{
	if ($itemParams->get('mega_showdesc', 1) && !empty($description))
	{
		$linktype = '<span class="menu-group with-description"><span class="menu-title">' . $item->title . '</span>' . $sticker . '<span class="menu-desc">' . $description . '</span></span>';
	}	
	else
	{
		$linktype = '<span class="menu-group"><span class="menu-title">' . $item->title . '</span>' . $sticker . '</span>';
	}
}
?>
<span <?php echo $class . $title; ?>>
	<?php echo $linktype; ?>
</span>