<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;
?>
<ul class="vpf-offcanvas-menu">
<?php
foreach ($list as $i => &$item)
{
	$class      = '';
	$itemParams = method_exists($item, 'getParams') ? $item->getParams() : $item->params;
	
	if($item->type == 'vmcategory')
	{
		$class .= 'vmcategory vmcat-' . $item->virtuemart_category_id;		
	}
	else
	{
		$class .= 'menuitem item-' . $item->id;
	}
	
	if (($item->id == $active_id) OR ($item->type == 'alias' AND $itemParams->get('aliasoptions') == $active_id))
	{
		$class .= ' current';
	}
	if (in_array($item->id, $path))
	{
		$class .= ' active';
	}
	elseif ($item->type == 'alias')
	{
		$aliasToId = $itemParams->get('aliasoptions');

		if (count($path) > 0 && $aliasToId == $path[count($path) - 1])
		{
			$class .= ' active';
		}
		elseif (in_array($aliasToId, $path))
		{
			$class .= ' alias-parent-active';
		}
	}
	elseif($item->type == 'vmcategory')
	{
		if($item->active)
		{
			$class .= ' active';
		}
	}	

	if ($item->type == 'separator')
	{
		$class .= ' divider';
	}

	if ($item->deeper)
	{
		$class .= ' deeper';
		
		if(strpos($class, 'active') !== false)
		{
			$class .= ' open';
		}
	}

	if ($item->parent)
	{
		$class .= ' parent';
	}

	if (!empty($class))
	{
		$class = ' class="' . trim($class) . '"';
	}

	echo '<li' . $class . '>';

	// Render the menu item.
	switch ($item->type) :
		case 'separator':
		case 'url':
		case 'component':
		case 'heading':
		case 'vmcategory':
			require $this->getMenuLayout('offcanvas_' . $item->type);
			break;

		default:
			require $this->getMenuLayout('offcanvas_url');
			break;
	endswitch;

	// The next item is deeper.
	if ($item->deeper)
	{
		echo '<ul class="nav-child">';
	}
	elseif ($item->shallower)
	{
		// The next item is shallower.
		echo '</li>';
		echo str_repeat('</ul></li>', $item->level_diff);
	}
	else
	{
		// The next item is on the same level.
		echo '</li>';
	}
}
?></ul>
