<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

// Note. It is important to remove spaces between elements.
$class      = $item->anchor_css ? 'class="' . $item->anchor_css . '" ' : '';
$title      = $item->anchor_title ? 'title="' . $item->anchor_title . '" ' : '';
$itemParams = method_exists($item, 'getParams') ? $item->getParams() : $item->params;

if ($itemParams->get('show_image', 0) && $item->thumbnail)
{
		$linktype = '<span class="menu-image">' . $item->thumbnail . '</span><span class="menu-title">' . $item->title . '</span>';
}
else
{
	$linktype = '<span class="menu-title">' . $item->title . '</span>';
}

if($item->deeper)
{
	$linktype .= '<span class="opener"></span>';
}

$flink = $item->link;
$flink = JFilterOutput::ampReplace(htmlspecialchars($flink));
?>
<a <?php echo $class; ?>href="<?php echo $flink; ?>" <?php echo $title; ?>><?php echo $linktype; ?></a>
