<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template Package
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * VP Smart Template Package Script
 * 
 * @since   1.0.0
 */
class pkg_VP_SmartInstallerScript
{
	private $pid = 20;
	
	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function install($adapter)
	{
		jimport('legacy.model.legacy');
		
		JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_plugins/models/', 'PluginsModel');
		
		$app       = JFactory::getApplication();
		$model     = JModelLegacy::getInstance('Plugin', 'PluginsModel');
		$plugin_id = $this->getPluginID();
		$enabled   = true;

		// First add pid
		$this->addPid();

		// If the plugin is not found or if the model is not loaded
		// we can not enable the VP Framework Plugin.
		if (!$plugin_id || !$model)
		{
			$enabled = false;
		}
		elseif (!$model->publish($plugin_id, 1))
		{
			$enabled = false;
		}

		$app->enqueueMessage('VP Smart Template package has been successfully installed in your site.');

		if (!$enabled)
		{
			$app->enqueueMessage('Please go to Plugin Manager and enable "System - VirtuePlanet Framework" plugin.');
		}
		
		$this->setCorrectPluginOrdering();
		
		return true;
	}

	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function update($adapter)
	{
		jimport('legacy.model.legacy');
		
		JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_plugins/models/', 'PluginsModel');
		
		$app       = JFactory::getApplication();
		$model     = JModelLegacy::getInstance('Plugin', 'PluginsModel');
		$plugin_id = $this->getPluginID();
		$enabled   = true;
		
		// First add pid
		$this->addPid();
		
		// If the plugin is not found or if the model is not loaded
		// we can not enable the VP Framework Plugin.
		if (!$plugin_id || !$model)
		{
			$enabled = false;
		}
		elseif (!$model->publish($plugin_id, 1))
		{
			$enabled = false;
		}

		$app->enqueueMessage('VP Smart Template package has been successfully updated in your site.');

		if (!$enabled)
		{
			$app->enqueueMessage('Please go to Plugin Manager and enable "System - VirtuePlanet Framework" plugin.');
		}
		
		// Remove outdated media
		jimport('joomla.filesystem.file');
		
		$outdatedFiles = array(

		);
		
		foreach ($outdatedFiles as $file)
		{
			$file_path = JPATH_SITE . '/' . $file;
			
			if (JFile::exists($file_path))
			{
				JFile::delete($file_path);
			}
		}
		
		$this->setCorrectPluginOrdering();
		
		return true;
	}

	/**
	 * Called before any type of action
	 *
	 * @param     string              $route      Which action is happening (install|uninstall|discover_install)
	 * @param     jadapterinstance    $adapter    The object responsible for running this script
	 *
	 * @return    boolean                         True on success
	 */
	public function preflight($route, $adapter)
	{
		return true;
	}


	/**
	 * Called after any type of action
	 *
	 * @param     string              $route      Which action is happening (install|uninstall|discover_install)
	 * @param     jadapterinstance    $adapter    The object responsible for running this script
	 *
	 * @return    boolean                         True on success
	 */
	public function postflight($route, $adapter)
	{
		return true;
	}

	/**
	* Private method to get the installed VP Framework plugin ID.
	* 
	* @return mixed(boolean/integer)      false if not found.
	*/
	private function getPluginID()
	{
		$db    = JFactory::getDBO();
		$query = $db->getQuery(true)
			->select('extension_id')
			->from('#__extensions')
			->where('folder = ' . $db->quote('system'))
			->where('element = ' . $db->quote('vpframework'));

		try
		{
			$db->setQuery($query);
			$extension_id = $db->loadResult();
		}
		catch(Exception $e)
		{
			// We can not through SQL error here.
			return false;
		}
		
		return $extension_id;
	}
	
	private function addPid()
	{
		jimport('joomla.registry.registry');
		
		$params = new JRegistry;
		$params->set('pid', $this->pid);
		$params = $params->toString();
		
		$db    = JFactory::getDBO();
		$query = $db->getQuery(true);
		
		$query->update($db->quoteName('#__extensions'))
			->set($db->quoteName('params') . ' = ' . $db->quote($params))
			->where($db->quoteName('type') . ' = ' . $db->quote('package'))
			->where($db->quoteName('element') . ' = ' . $db->quote('pkg_vp_smart'));

		try
		{
			$db->setQuery($query);
			$db->execute();
		}
		catch(Exception $e)
		{
			$app = JFactory::getApplication();
			$app->enqueueMessage('Failed to update package Product ID required for Live Update.');
		}
	}
	
	private function setCorrectPluginOrdering()
	{
		$db    = JFactory::getDBO();
		$query = $db->getQuery(true);
		
		$query->select($db->quoteName('extension_id'))
			->select($db->quoteName('element'))
			->select($db->quoteName('ordering'))
			->from($db->quoteName('#__extensions'))
			->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
			->where($db->quoteName('folder') . ' = ' . $db->quote('system'))
			->order($db->quoteName('ordering'));
		
		try
		{
			$db->setQuery($query);
			$plugins = $db->loadObjectList();
		}
		catch(Exception $e)
		{
			return false;
		}
		
		if (empty($plugins))
		{
			return false;
		}
		
		$ordering = 0;
		$me = null;
		
		foreach ($plugins as $key => $plugin)
		{
			if ($plugin->element == 'vpframework')
			{
				$me = $plugin;
			}
			
			if ($plugin->element == 'sef')
			{
				$ordering = (int) $plugin->ordering;
				
				unset($plugins[$key]);
				
				// Stop. We need to have the plugins ordered after sef plugin
				break;
			}
			else
			{
				unset($plugins[$key]);
			}
		}
		
		if (!$me)
		{
			return false;
		}
		
		if ($me->ordering > $ordering)
		{
			// Already have correct order
			return true;
		}
		
		$case = array();
		$where = array();
		
		$ordering++;
		
		$case[] = 'WHEN ' . $me->extension_id . ' THEN ' . $ordering;
		$where[] = $me->extension_id;
		
		foreach ($plugins as $plugin)
		{
			$ordering++;
			
			$case[] = 'WHEN ' . $plugin->extension_id . ' THEN ' . $ordering;
			$where[] = $plugin->extension_id;
		}
		
		$query->clear()
			->update($db->quoteName('#__extensions'))
			->set($db->quoteName('ordering') . ' = CASE extension_id ' . implode(' ', $case) . ' END')
			->where($db->quoteName('extension_id') . ' IN (' . implode(',', $where) . ')');

		try
		{
			$db->setQuery($query);
			$db->execute();
		}
		catch(Exception $e)
		{
			return false;
		}
		
		return true;
	}
}
