<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          http://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

VmConfig::loadConfig();

JLoader::register('CurrencyDisplay',             JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/currencydisplay.php');
JLoader::register('VirtueMartModelCustomfields', JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/customfields.php');

VmConfig::loadJLang('com_virtuemart', true);

abstract class ModVPCompareHelper
{
	public static function getAjax()
	{
		if (JModuleHelper::isEnabled('mod_vp_compare'))
		{
			if ($module = JModuleHelper::getModule('mod_vp_compare'))
			{
				$context = JModuleHelper::renderModule($module);

				return self::_return($context);
			}
		}
	}
	
	private static function _return($context)
	{
		$obLevel = ob_get_level();
		
		if ($obLevel)
		{
			while ($obLevel > 0) 
			{
				ob_end_clean();
				$obLevel --;
			}
		}
		else
		{
			ob_clean();
		}
		
		if (isset($_SERVER['HTTP_ACCEPT']) && (strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false)) 
		{
			header('Content-type: application/text');
		} 
		else 
		{
			header('Content-type: application/json');
		}
		header('Cache-Control: public,max-age=1,must-revalidate');
		header('Expires: ' . gmdate('D, d M Y H:i:s', ($_SERVER['REQUEST_TIME'] + 1)) . ' GMT');
		header('Last-modified: ' . gmdate('D, d M Y H:i:s', $_SERVER['REQUEST_TIME']) . ' GMT');
		if (function_exists('header_remove')) 
		{
			header_remove('Pragma');
		}
			
		echo json_encode(array('html' => $context));
		
		JFactory::getApplication()->close();
	}
}
