<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Custom Filter Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Custom Filter Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

$doc->addStyleSheet(JUri::root(true) . '/modules/mod_vp_custom_filter/assets/css/module.css?ver=3.2');
$doc->addScript(JUri::root(true) . '/modules/mod_vp_custom_filter/assets/js/module.min.js?ver=3.2');

$data_ajax = $use_ajax ? ' data-vpcfajax="true"' : '';
?>
<div class="vpcf-filter-module-container">
	<div id="vpcf-filter-module-<?php echo $module->id ?>" class="vpcf-filter-module">
		<form method="get" action="<?php echo htmlspecialchars($actionUrl, ENT_COMPAT, 'UTF-8'); ?>" class="form-vpcf"<?php echo $data_ajax ?>>
			<div class="vpcf-hidden-fields">
				<?php echo $hiddenFields; // Adding hidden fields at top for proper url redering ?>
			</div>
			<?php foreach ($form->getFieldsets() as $fieldset) : ?>
				<?php $fields = $form->getFieldset($fieldset->name); ?>
				<?php if (count($fields)) : ?>
					<?php foreach ($fields as $field) : // Iterate through the fields in the set and display them. ?>
						<?php if ($field->hidden) : // If the field is hidden, just display the input. ?>
							<?php echo $field->input; ?>
						<?php else : ?>
							<h3 class="mod-header"><?php echo strip_tags($field->label); ?></h3>
							<?php echo $field->input; ?>
						<?php endif; ?>
						<?php endforeach; ?>
				<?php endif; ?>
			<?php endforeach; ?>
		</form>
	</div>
</div>
