<?php

/*
 *  pgn4web javascript chessboard
 *  copyright (C) 2009, 2010 Paolo Casaschi
 *  see README file and http://pgn4web.casaschi.net
 *  for credits, license and more details
 */

defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');
JFormHelper::loadFieldClass('color');

class JFormFieldJSColor extends JFormFieldColor
{
	protected $type = 'JSColor';
	
	protected function getInput()
	{
		if(version_compare(JVERSION, '3.0', '<'))
		{
			global $jscolorLoaded;
			
			if (!$jscolorLoaded)
			{
				JFactory::getDocument()->addScript(JUri::root(true) . '/modules/mod_vp_manufacturer_carousel/fields/jscolor/jscolor.js');
				$jscolorLoaded = true;
			}
			
			$onchange = $this->element['onchange'] ? ' onchange="'.(string) $this->element['onchange'].'"' : '';
			$class    = ' class="color {required:false}"';
			$html     = '<input type="text" name="' . $this->name . '" id="' . $this->id . '"' . ' value="' . htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') . '"' . $class.$onchange . ' />';
		}
		else
		{
			$html = parent::getInput();
		}
		
		return $html;
	}
}
