<?php 
/**
 * --------------------------------------------------------------------------------------------
 * VP Manufacturer Carousel - Joomla! Module for VirtueMart Store
 * --------------------------------------------------------------------------------------------
 * @package    VP Manufacturer Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

$Itemid = $Itemid ? '&Itemid=' . $Itemid : '';
?>
<div class="vp-manufacturer-carousel-cont">
	<?php if(!empty($headerText)) : ?>
		<div class="vp-manufacturer-carousel-header-text">
			<?php echo $headerText ?>
		</div>
	<?php endif; ?>
	<div id="<?php echo $module_id ?>" class="vp-manufacturer-carousel owl-carousel side-nav-theme">
		<?php foreach ($manufacturers as $manufacturer) : ?>
			<?php
			if($linkType == 'listing')
			{
				$link  = JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $manufacturer->virtuemart_manufacturer_id . $Itemid);
				$title = JText::sprintf('COM_VIRTUEMART_PRODUCT_FROM_MF', $manufacturer->mf_name);
			}
			else
			{
				$link  = JRoute::_('index.php?option=com_virtuemart&view=manufacturer&virtuemart_manufacturer_id=' . $manufacturer->virtuemart_manufacturer_id);
				$title = $manufacturer->mf_name;
			}
			
			if($params->get('lazyLoad', 1))
			{
				$image = $manufacturer->images[0]->displayMediaThumb('class="img-carousel lazyOwl owl-lazy"', false);
				$logo  = str_replace('src="', 'data-src="', $image);
			}
			else
			{
				$logo = $manufacturer->images[0]->displayMediaThumb('class="img-carousel"', false);
			} ?>
			<?php if(!empty($manufacturer->images[0])) : ?>
				<div class="manufacturer-carousel-inner">
					<?php if($linkType == 'none') : ?>
						<?php echo $logo ?>
					<?php else : ?>
						<a href="<?php echo $link; ?>" title="<?php echo $title ?>"><?php echo $logo ?></a>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		<?php endforeach; ?>
	</div>
	<?php if(!empty($footerText)) : ?>
		<div class="vp-manufacturer-carousel-footer-text">
			<?php echo $footerText ?>
		</div>
	<?php endif; ?>
</div>