/**
 * --------------------------------------------------------------------------------------------
 * VP Mini Cart Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Mini Cart Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
 */
;
(function(a) {
	var addToCartModPool = {};
	var itemState = 'hidden';

	function initCartModButton() {
		if (!window.vp_minicart_module_class) {
			window.vp_minicart_module_class = 'vp-minicart';
		}
		a('.' + window.vp_minicart_module_class).find('.vp-minicart-inner').hover(function(e) {
			a('.vp-minicart-dropdown', this).addClass('show').removeClass('hide');
		}, function() {
			a('.vp-minicart-dropdown', this).addClass('hide').removeClass('show');
		});
	}

	a(document).ready(function() {
		a(document).on('updateVirtueMartCartModule', function(event) {
			if (addToCartModPool.hasOwnProperty('update') && addToCartModPool['update'].readystate != 4) {
				addToCartModPool['update'].abort();
			}
			addToCartModPool['update'] = a.ajax({
				dataType: 'json',
				type: 'GET',
				cache: false,
				url: window.juri,
				data: {
					'vpajaxmodule': 'mod_vp_mini_cart',
					'Itemid': window.vp_minicart_module_itemid
				},
				success: function(data, textStatus, jqXHR) {
					console.log(data);
					if (!data.html) {
						return;
					}
					if (a.type(data.html) == 'string') {
						data.html = a.parseHTML(data.html);
					}

					if (!window.vp_minicart_module_class) {
						window.vp_minicart_module_class = 'vp-minicart';
					}

					var html = a(data.html).filter('.' + window.vp_minicart_module_class).html();

					if (!html) {
						html = data.html;
					}

					a('.' + window.vp_minicart_module_class).html(html);

					initCartModButton();

					a(document).trigger('vpminicartUpdated', [data.html]);
				},
				error: function(jqXHR, textStatus, errorThrown) {
					console.log(textStatus);
					console.log(errorThrown);
				}
			});
		});

		initCartModButton();
	});
})(jQuery);