<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die();

use Joomla\Registry\Registry;

JFormHelper::loadFieldClass('list');

JLoader::register('VmConfig',        JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');
JLoader::register('ShopFunctions',   JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/shopfunctions.php');
JLoader::register('TableCategories', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/categories.php');
JLoader::register('VmModel',         JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/vmmodel.php');

VmConfig::loadConfig();

class JFormFieldVMProducts extends JFormFieldList
{
	public $type = 'VMProducts';
	
	protected static $products = null;
	
	protected function getInput()
	{
		$id    = isset($this->element['id']) ? $this->element['id'] : null;
		$cssId = '#' . $this->getId($id, $this->element['name']);
		
		if (is_string($this->value))
		{
			$this->value = explode(',', $this->value);
		}
		
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			$data   = $this->getLayoutData();
			
			$class         = !empty($data['class']) ? $data['class'] : '';
			$hint          = !empty($data['hint']) ? $data['hint'] : '';
			$allowCustom   = !empty($data['allowcustom']) ? $data['allowcustom'] : false;
			$required      = !empty($data['required']) ? $data['required'] : false;
			$minTermLength = !empty($data['mintermlength']) ? $data['mintermlength'] : 2;
			$dataAttribute = !empty($data['data']) ? $data['data'] : '';
			
			$attr  = '';
			$attr .= !empty($data['class']) ? ' class="' . $data['class'] . '"' : '';
			$attr .= ' placeholder="' . htmlspecialchars($hint ?: JText::_('JGLOBAL_TYPE_OR_SELECT_SOME_TAGS'), ENT_COMPAT, 'UTF-8', false) . '" ';
			$attr .= $dataAttribute;

			if ($allowCustom)
			{
				$attr .= $allowCustom ? ' allow-custom' : '';
				$attr .= $allowCustom ? ' new-item-prefix="#new#"' : '';
			}

			$attr .= ' remote-search';
			$attr .= ' url="' . JUri::root(true) . '/index.php?option=com_ajax&plugin=vpframework&format=json&vpfmethod=getProducts"';
			$attr .= ' term-key="like"';
			$attr .= ' min-term-length="' . $minTermLength . '"';

			if ($required)
			{
				$attr .= ' required';
			}
			
			JText::script('JGLOBAL_SELECT_PRESS_TO_SELECT');

			JFactory::getDocument()->getWebAssetManager()
				->usePreset('choicesjs')
				->useScript('webcomponent.field-fancy-select');
			
			$html = parent::getInput();
			$html = '<joomla-field-fancy-select ' . $attr . '>' . $html . '</joomla-field-fancy-select>';
			
			return $html;
		}
		else
		{
			$chosenAjaxSettings = new Registry(
				array(
					'selector'      => $cssId,
					'type'          => 'GET',
					'url'           => JUri::root(true) . '/index.php?option=com_ajax&plugin=vpframework&format=json&vpfmethod=getProducts',
					'dataType'      => 'json',
					'jsonTermKey'   => 'like',
					'minTermLength' => 2
				)
			);

			JHtml::_('formbehavior.ajaxchosen', $chosenAjaxSettings);
			
			return parent::getInput();
		}
	}
	
	protected function getOptions()
	{
		$options = array();
		
		if (!empty($this->value))
		{
			VmConfig::loadJLang('com_virtuemart', true);
			
			$model       = VmModel::getModel('Product');
			$product_ids = array_map('intval', $this->value);
			$products    = $model->getProducts($product_ids);
			
			if (!empty($products))
			{
				foreach ($products as $product)
				{
					$value = (int) $product->virtuemart_product_id;
					$text  = htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8', false);
					
					$options[] = JHTML::_('select.option', $value, $text);
				}
			}
		}
		
		return array_merge(parent::getOptions(), $options);
	}
}