<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

VmConfig::loadConfig();

JLoader::register('calculationHelper',      JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/calculationh.php');
JLoader::register('CurrencyDisplay',        JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/currencydisplay.php');
JLoader::register('VirtueMartModelVendor',  JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/vendor.php');
JLoader::register('VirtueMartModelProduct', JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/product.php');
JLoader::register('VmImage',                JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/image.php');
JLoader::register('shopFunctionsF',         JPATH_SITE . '/components/com_virtuemart/helpers/shopfunctionsf.php');

abstract class ModVPProductCorouselHelper 
{
	public static function getList($params)
	{
		VmConfig::loadConfig();
		VmConfig::loadJLang('com_virtuemart', true);
		VmConfig::loadJLang('mod_virtuemart_product', true);
		
		$group             = $params->get('product_group', 'featured');
		$max_items         = $params->get('max_items', 2 );
		$product_ids       = (array) $params->get('product_id', array());
		$category_id       = $params->get('virtuemart_category_id', null); 
		$filter_category   = !empty($category_id) ? true : false;
		$show_price        = $params->get('show_price', 1);
		$show_addtocart    = $params->get( 'show_addtocart', 1);
		$model             = VmModel::getModel('Product');
		$ratingModel       = VmModel::getModel('ratings');
		$model->withRating = $ratingModel->showRating();

		if ($group == 'custom')
		{
			if (!empty($product_ids))
			{
				if (isset(VirtueMartModelProduct::$_alreadyLoadedIds))
				{
					VirtueMartModelProduct::$_alreadyLoadedIds = array();
				}
				
				$products = $model->getProducts($product_ids);
				
				if (isset(VirtueMartModelProduct::$_alreadyLoadedIds))
				{
					VirtueMartModelProduct::$_alreadyLoadedIds = array();
				}
			}
			else
			{
				$products = array();
			}
		}
		else
		{
			if (isset(VirtueMartModelProduct::$_alreadyLoadedIds))
			{
				VirtueMartModelProduct::$_alreadyLoadedIds = array();
			}
			
			$products = $model->getProductListing($group, $max_items, $show_price, true, false, $filter_category, $category_id);
			
			if (isset(VirtueMartModelProduct::$_alreadyLoadedIds))
			{
				VirtueMartModelProduct::$_alreadyLoadedIds = array();
			}
		}
		
		if (!empty($products))
		{
			$model->addImages($products, 1);
			
			$customfieldsModel = VmModel::getModel('Customfields');
			
			JLoader::register('vmCustomPlugin', JPATH_VM_PLUGINS . '/vmcustomplugin.php');
			
			foreach ($products as $key => $productItem)
			{
				if (!empty($productItem->customfields))
				{
					$product = clone($productItem);
					$customfields = array();
					
					foreach ($productItem->customfields as $cu)
					{
						$customfields[] = clone($cu);
					}

					$customfieldsSorted = array();
					$customfieldsModel->displayProductCustomfieldFE($product, $customfields);

					foreach ($customfields as $k => $custom)
					{
						if (!empty($custom->layout_pos))
						{
							$customfieldsSorted[$custom->layout_pos][] = $custom;
							unset($customfields[$k]);
						}
					}

					$customfieldsSorted['normal'] = $customfields;
					$product->customfieldsSorted = $customfieldsSorted;

					unset($product->customfields);

					$products[$key] = $product;
				} 
				else
				{
					$products[$key] = $productItem;
				}
			}
		}

		return $products;
	}
	
	public static function isResponsive(&$params)
	{
		if (!$params->get('responsive', 1)) 
		{
			return false;
		}
		
		$responsive_items = $params->get('responsive_items', null);
		$array = array();
		
		if (!empty($responsive_items))
		{
			if (strpos($responsive_items, ',') !== false)
			{
				$responsive_items = explode(',', $responsive_items);
				
				foreach ($responsive_items as $responsive_item)
				{
					if (!empty($responsive_item) && strpos($responsive_item, ':')) 
					{
						list($key, $value) = explode(':', $responsive_item);
						$key = floatval($key);
						$value = intval($value);
						
						if (is_numeric($key) && $value)
						{
							$array[] = $key . ':{items: ' . $value . '}';
						}
					}
				}
			}
		}
		
		if (empty($array))
		{
			return false;
		}
		
		$jsObject  = '{' . implode(',', $array) . '}';
		
		$params->set('responsive_items', $jsObject);
		
		return true;
	}
}