<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');
JLoader::register('ModVPProductCorouselHelper', __DIR__ . '/helper.php');

VmConfig::loadConfig();

$app                        = JFactory::getApplication();
$template                   = $app->getTemplate();
$input                      = $app->input;
$vendorId                   = $input->getInt('vendorid', 1);
$virtuemart_currency_id     = $app->getUserStateFromRequest('virtuemart_currency_id', 'virtuemart_currency_id', $input->getInt('virtuemart_currency_id', 0));

$show_price                 = $params->get('show_price', 1);
$show_addtocart             = $params->get('show_addtocart', 2);
$show_qty_selector          = $params->get('show_qty_selector', 0);
$showRating                 = $params->get('show_rating', 2);
$load_owlcarousel           = $params->get('load_owlcarousel', 1);

$margin                     = (int) $params->get('margin', 15);
$itemsDesktop               = (int) $params->get('itemsDesktop', 4);
$itemsDesktopSmall          = (int) $params->get('itemsDesktopSmall', 3);
$itemsTablet                = (int) $params->get('itemsTablet', 3);
$itemsMobile                = (int) $params->get('itemsMobile', 2);
$lazyLoad                   = $params->get('lazyLoad', 1) ? 'true' : 'false';
$navigation                 = $params->get('navigation', 1) ? 'true' : 'false';
$pagination                 = $params->get('pagination', 0) ? 'true' : 'false';
$pagination_position        = $params->get('pagination_position', 'bottom-right');
$loop                       = $params->get('loop', 1) ? 'true' : 'false';
$rewindNav                  = $params->get('rewindNav', 1) ? 'true' : 'false';
$slideSpeed                 = (int) $params->get('slideSpeed', 200);
$paginationSpeed            = (int) $params->get('paginationSpeed', 800);
$rewindSpeed                = (int) $params->get('rewindSpeed', 600);
$autoplayTimeout            = (int) $params->get('autoplayTimeout', 10000);
$autoplay                   = $params->get('autoplay', 1) ? $autoplayTimeout : 'false';
$stopOnHover                = $params->get('stopOnHover', 1) ? 'true' : 'false';

$has_vpframework            = JPluginHelper::isEnabled('system', 'vpframework');
$currency                   = CurrencyDisplay::getInstance();
$moduleclass_sfx            = htmlspecialchars($params->get('moduleclass_sfx', ''));
$module_id                  = 'vp-product-carousel-' . $module->id;
$cacheEnabled               = $params->get('vpcache', 1);
$cacheEnabled               = ($params->get('product_group', '') == 'recent') ? false : $cacheEnabled;
$cache_time                 = $params->get('vpcache_time', 300);
$theme                      = 'carousel-nav-top';

JHtml::_('jquery.framework');
$doc = JFactory::getDocument();
$base = JUri::base(true);

if ($show_addtocart) 
{
	vmJsApi::jPrice();
	vmJsApi::cssSite();
}

if ($has_vpframework)
{
	if (!class_exists('plgSystemVPFrameworkHelper'))
	{
		require(JPATH_SITE . '/plugins/system/vpframework/helper.php');
	}

	// Register helper class autoloader
	plgSystemVPFrameworkHelper::autoloadRegister();
	
	$template = plgSystemVPFrameworkHelper::getTemplate();
	
	if ($template->params->get('vpframework', 0))
	{
		$theme = $template->params->get('vm_product_carousel_theme', 'carousel-nav-top');
	}
	
	$template->loadJSLibraries(array('jquery.owl.carousel.min'));

	JHtml::stylesheet('vpframework/jquery.owl.transitions.css', array(), true);
}
elseif ($load_owlcarousel)
{
	$doc->addScript($base . '/modules/mod_vp_product_carousel/assets/js/jquery.owl.carousel.min.js');
	$doc->addStyleSheet($base . '/modules/mod_vp_product_carousel/assets/css/jquery.owl.carousel.min.css');
	$doc->addStyleSheet($base . '/modules/mod_vp_product_carousel/assets/css/jquery.owl.transitions.css');
}

if (file_exists(JPATH_SITE . '/templates/' . $template . '/js/mod_vp_product_carousel/module.js'))
{
	$doc->addScript($base . '/templates/' . $template . '/js/mod_vp_product_carousel/module.js');
}
else
{
	$doc->addScript($base . '/modules/mod_vp_product_carousel/assets/js/module.js');
}

if (file_exists(JPATH_SITE . '/templates/' . $template . '/css/mod_vp_product_carousel/module.css'))
{
	$doc->addStyleSheet($base . '/templates/' . $template . '/css/mod_vp_product_carousel/module.css');
}
else
{
	$doc->addStyleSheet($base . '/modules/mod_vp_product_carousel/assets/css/module.css');
}

$js = "
jQuery(document).ready(function($){
  $('#" . $module_id . "').owlCarousel({
    items: " . $itemsDesktop . ",
    itemsDesktop: [1200, " . $itemsDesktop . "],
    itemsDesktopSmall: [992, " . $itemsDesktopSmall . "],
    itemsTablet: [768 ," . $itemsTablet . "],
    itemsMobile: [479 ," . $itemsMobile . "],
    lazyLoad: " . $lazyLoad . ",
    autoPlay: " . $autoplay . ",
    theme: '" . $theme . "',
    navigation: " . $navigation . ",
    pagination: " . $pagination . ",
    slideSpeed: " . $slideSpeed . ",
    paginationSpeed: " . $paginationSpeed . ",
    rewindSpeed: " . $rewindSpeed . ",
    stopOnHover: " . $stopOnHover . ",
    rewindNav: " . $rewindNav . ",
    navigationText: false,
    autoHeight: false,
    scrollPerPage: true,
    afterAction: function() {
    	$(document).trigger('product.carousel.afterAction', [this, " . $margin . "]);
    },
    afterInit: function() {
    	$(document).trigger('product.carousel.afterInit', [this, " . $margin . "]);
    },
    afterLazyLoad: function(e) {
    	$(document).trigger('product.carousel.afterAction', [this, " . $margin . "]);
    }
  });
});
";

vmJsApi::addJScript('ModVPProductCorousel' . $module->id, $js);

if ($showRating)
{
	$maxrating  = VmConfig::get('vm_maximum_rating_scale', 5);
	$hint       = array();

	for($i=1; $i<=$maxrating; $i++)
	{
		$hint[] = "'" . $i . " " . vmText::_('COM_VIRTUEMART_REVIEW_STARS') . "'";
	}

	$hint   = '[' . implode(',', $hint) . ']';
	$rateJS = "
	  jQuery(document).ready(function($) {
	    $('.vm-product-rating').raty({
	      score: function() {
	        return $(this).data('score') ? $(this).data('score') : 0;
	      },
	      numberMax: " . $maxrating . ",
	      number: " . $maxrating . ",
	      hints: " . $hint . ",
	      starType: 'i',
	      halfShow: true,
	      readOnly: true,
	      noRatedMsg: '" . vmText::_('COM_VIRTUEMART_UNRATED') . "'
	    });
	  });
	";

	vmJsApi::addJScript('productRating', $rateJS);
}

$key    = 'id:' . $module->id . 'params:' . serialize($params->toArray());
$cache  = JFactory::getCache('mod_vp_product_carousel', 'output');

if (!empty($cache_time)) $cache->setLifeTime($cache_time);
if (!$cacheEnabled) $cache->setCaching(0);

$output = $cache->get($key);

if (empty($output))
{
	$products = ModVPProductCorouselHelper::getList($params);
	$output = '';
	
	if (!empty($products))
	{
		$total = count($products);
		ob_start();
		require JModuleHelper::getLayoutPath('mod_vp_product_carousel', $params->get('layout', 'default'));
		$output = ob_get_clean();
	}
	
	$cache->store($output, $key);
}

if (!empty($output))
{
	echo $output;
	echo vmJsApi::writeJS();
}
