<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2015 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

VmConfig::loadConfig();

JLoader::register('calculationHelper',      JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/calculationh.php');
JLoader::register('CurrencyDisplay',        JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/currencydisplay.php');
JLoader::register('VmImage',                JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/image.php');
JLoader::register('VirtueMartModelVendor',  JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/vendor.php');
JLoader::register('VirtueMartModelProduct', JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/product.php');
JLoader::register('shopFunctionsF',         JPATH_SITE . '/components/com_virtuemart/helpers/shopfunctionsf.php');

abstract class ModVPProductListHelper 
{
	public static function getList($params)
	{
		VmConfig::loadJLang('com_virtuemart', true);
		
		$group             = $params->get('product_group', 'featured');
		$max_items         = $params->get('max_items', 2 );
		$product_ids       = (array) $params->get('product_id', array());
		$category_id       = $params->get('virtuemart_category_id', null); 
		$filter_category   = !empty($category_id) ? true : false;
		$show_price        = $params->get('show_price', 1);
		$model             = VmModel::getModel('Product');
		$ratingModel       = VmModel::getModel('ratings');
		$model->withRating = $params->get('show_rating', 1) && $ratingModel->showRating();

		if ($group == 'custom')
		{
			if (!empty($product_ids))
			{
				if (isset(VirtueMartModelProduct::$_alreadyLoadedIds))
				{
					VirtueMartModelProduct::$_alreadyLoadedIds = array();
				}
				
				$products = $model->getProducts($product_ids);
				
				if (isset(VirtueMartModelProduct::$_alreadyLoadedIds))
				{
					VirtueMartModelProduct::$_alreadyLoadedIds = array();
				}
			}
			else
			{
				$products = array();
			}
		}
		else
		{
			if (isset(VirtueMartModelProduct::$_alreadyLoadedIds))
			{
				VirtueMartModelProduct::$_alreadyLoadedIds = array();
			}
			
			$products = $model->getProductListing($group, $max_items, $show_price, true, false, $filter_category, $category_id);
			
			if (isset(VirtueMartModelProduct::$_alreadyLoadedIds))
			{
				VirtueMartModelProduct::$_alreadyLoadedIds = array();
			}
		}
		
		if (!empty($products))
		{
			$model->addImages($products, 1);
		}

		return $products;
	}
}