<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Responsive Slider - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Responsive Slider Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

class modVPResponsiveSliderHelper 
{
	public static function getList(&$params)
	{
		$slides = $params->get('slides', array());
		
		if (empty($slides))
		{
			return false;
		}
		
		foreach ($slides as $key => &$slide)
		{
			$slide = (object) $slide;
			
			if (!property_exists($slide, 'published'))
			{
				$slide->published = 1;
			}
			
			if (empty($slide->image) || !$slide->published)
			{
				unset($slides[$key]);
				
				continue;
			}
			
			$slide->alt   = htmlspecialchars($slide->alt, ENT_COMPAT, 'UTF-8', false);
			$slide->image = self::_getClean($slide->image);
		}

		return array_values($slides);
	}
	
	public static function getAnimations()
	{
		jimport('joomla.form.helper');

		JFormHelper::addFieldPath(__DIR__ . '/fields');
		
		$VPFDynamic = JFormHelper::loadFieldType('VPFDynamic', false);
		$options    = $VPFDynamic->getAnimations('entrance');
		$animations = array();
		
		if (!empty($options))
		{
			foreach ($options as $option)
			{
				$animations[] = $option->value;
			}
		}

		return $animations;
	}
	
	protected static function _getClean($url)
	{
		$url = trim($url);
		
		if ($url && pathinfo($url, PATHINFO_EXTENSION) && substr($url, 0, 4) != 'http')
		{
			$url = JURI::root(true) . '/' . $url;
		}
		
		return $url; 
	}
}
