<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Responsive Slider - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Responsive Slider Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

if ($params->get('lazyLoad', 0))
{
	$image_element = '<img src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==" data-src="||SLIDE-IMAGE||" alt="||SLIDE-ALT||" class="img-responsive lazyOwl" />';
}
else
{
	$image_element = '<img src="||SLIDE-IMAGE||" alt="||SLIDE-ALT||" class="img-responsive" />';
}

$image_tags = array('||SLIDE-IMAGE||', '||SLIDE-ALT||');
?>
<div class="vpfrs-cont<?php echo $moduleclass_sfx ?>">
	<div id="<?php echo $module_id ?>" class="owl-carousel vpfrs-theme pagination-<?php echo $pagination_position ?>">
		<?php foreach ($slides as $slide):?>
			<div class="vpfrs-item">
				<div class="vpfrs-image-cont">
					<?php if (!empty($slide->link)) : ?>
						<a href="<?php echo $slide->link ?>">
							<?php echo str_replace($image_tags, array($slide->image, $slide->alt), $image_element); ?>
						</a>
					<?php else : ?>
						<?php echo str_replace($image_tags, array($slide->image, $slide->alt), $image_element); ?>
					<?php endif; ?>
				</div>
				<?php if (!empty($slide->caption)) : ?>
					<?php if (!empty($slide->link)) : ?>
						<a href="<?php echo $slide->link ?>">
							<div class="vpfrs-caption caption-position-<?php echo $slide->caption_position ?> caption-alignment-<?php echo $slide->caption_alignment ?>" data-animation="<?php echo $slide->caption_animation ?>">
								<div class="vpfrs-caption-inner">
									<?php echo $slide->caption ?>
								</div>
							</div>
						</a>
					<?php else : ?>
						<div class="vpfrs-caption caption-position-<?php echo $slide->caption_position ?> caption-alignment-<?php echo $slide->caption_alignment ?>" data-animation="<?php echo $slide->caption_animation ?>">
							<div class="vpfrs-caption-inner">
								<?php echo $slide->caption ?>
							</div>
						</div>
					<?php endif; ?>
				<?php endif; ?>
			</div>
		<?php endforeach; ?>
	</div>
</div>