<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');
JFormHelper::loadFieldClass('list');

/**
* Generates list of jQuery easings
*/
class JFormFieldEasing extends JFormFieldList
{
	public $type = 'Easing';

	protected function getOptions()
	{
		$easings = array(
		             'linear',
		             'swing',
		             'easeInQuad',
		             'easeOutQuad',
		             'easeInOutQuad',
		             'easeInCubic',
		             'easeOutCubic',
		             'easeInOutCubic',
		             'easeInQuart',
		             'easeOutQuart',
		             'easeInOutQuart',
		             'easeInQuint',
		             'easeOutQuint',
		             'easeInOutQuint',
		             'easeInSine',
		             'easeOutSine',
		             'easeInOutSine',
		             'easeInExpo',
		             'easeOutExpo',
		             'easeInOutExpo',
		             'easeInCirc',
		             'easeOutCirc',
		             'easeInOutCirc',
		             'easeInElastic',
		             'easeOutElastic',
		             'easeInOutElastic',
		             'easeInBack',
		             'easeOutBack',
		             'easeInOutBack',
		             'easeInBounce',
		             'easeOutBounce',
		             'easeInOutBounce'
		            );

		$options = array();
		
		foreach ($easings as $easing)
		{
			$options[] = JHtml::_('select.option', $easing, preg_replace('/(?<!\ )[A-Z]/', ' $0', ucfirst($easing)));
		}
		
		return array_merge(parent::getOptions(), $options);
	}
}