<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldMultilist extends JFormFieldList
{
	protected $type = 'Multilist';
	
	protected function getOptions()
	{
		if (!empty($this->value) && is_string($this->value) && strpos($this->value, ',') !== false)
		{
			$parts = explode(',', $this->value);
			
			$this->value = array_map('trim', $parts);
		}
		
		if (version_compare(JVERSION, '4.0.0', 'ge') && $this->multiple)
		{
			$this->layout = 'joomla.form.field.list-fancy-select';
		}
		
		return parent::getOptions();
	}
}