<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('text');

class JFormFieldTexttotag extends JFormFieldText
{
	protected $type = 'Texttotag';

	function getInput()
	{
		JHtml::_('jquery.framework');
		JHtml::_('script', 'system/html5fallback.js', array('relative' => true, 'version' => 'auto'));
		
		$doc = JFactory::getDocument();
		$root = JUri::root(true);
		
		$doc->addScript($root . '/media/vpframework/js/angular.min.js');
		
		JHtml::_('bootstrap.framework');
		
		$doc->addScript($root . '/media/vpframework/js/bootstrap-tagsinput.js');
		$doc->addScript($root . '/media/vpframework/js/bootstrap-tagsinput-angular.js');
		$doc->addStyleSheet($root . '/media/vpframework/css/bootstrap-tagsinput.css');
		
		$doc->addScriptDeclaration("
		jQuery(function($) {
			$('#{$this->id}').tagsinput({
					trimValue: true,
					allowDuplicates: false,
					tagClass: 'label'
			});
		});
		");
		
		$bottom = !empty($this->element['bottom']) ? $this->element['bottom'] : null;
		
		$html  = parent::getInput();
		$html .= '<div class="clearfix"></div>';
		
		if ($bottom)
		{
			$html .= '<div class="muted small">' . JText::_($bottom) . '</div>';
		}
		
		return $html;
	}
}