<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldVPTheme extends JFormFieldList
{
	protected $type = 'VPTheme';
	
	function getInput()
	{
		$helper      = VPFrameworkAdmin::getInstance();
		$template    = $helper->getTemplate();
		$context     = 'com_templates.style.tpl_' . $template->template;
		$newTheme    = JFactory::getApplication()->getUserState($context . '.new_theme', null);
		$this->value = $this->value ? $this->value : 'default';
		$this->class = ($newTheme !== null) ? $this->class . ' hide' : $this->class;
		$textClass   = ($newTheme !== null) ? ' vp-new-theme-field' : ' hide vp-new-theme-field';
		$name        = $this->getAttribute('name');
		$newName     = str_replace($name, 'new_theme', $this->name);
		$newID       = str_replace($name, 'new_theme', $this->id);
		$newAttr     = ($newTheme !== null) ? ' required' : ' disabled';
		
		JHtml::_('jquery.framework');
		$doc = JFactory::getDocument();
		$token = JSession::getFormToken();
		
		$doc->addScriptDeclaration("
		jQuery(document).ready(function($) {
			if ($('select#{$this->id}').hasClass('hide')) {
				$('#{$this->id}_chzn').addClass('hide');
			}
		});
		function vpAddNewTheme(button) {
			var $ = jQuery.noConflict();
			var select = $('select#{$this->id}');
			var chosen = $('#{$this->id}_chzn');
			var text = $('input#{$newID}');
			if (select.hasClass('hide')) {
				select.removeClass('hide');
				chosen.removeClass('hide');
				text.addClass('hide').attr('disabled', true).removeAttr('required');
				$(button).find('.for-list').addClass('hide');
				$(button).find('.for-new').removeClass('hide');
				
			} else {
				select.addClass('hide');
				chosen.addClass('hide');
				text.removeClass('hide').removeAttr('disabled').attr('required', true);
				$(button).find('.for-list').removeClass('hide');
				$(button).find('.for-new').addClass('hide');
			}
			return false;
		}
		");
		
		$html = '';
		
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			$html .= '<div class="input-group">';
		}
		
		$html .= parent::getInput();
		$html .= '<label for="' . $newID . '" class="element-invisible">New Theme Name</label>';
		$html .= '<input type="text" name="' . $newName . '" id="' . $newID . '" class="form-control ' . $textClass . '" value="' . $newTheme . '" style="margin-right:4px;" placeholder="New theme name"' . $newAttr . '/>';
		
		if ($newTheme !== null)
		{
			$html .= '<button type="button" class="btn btn-outline-secondary" onclick="return vpAddNewTheme(this);">';
			$html .= '<span class="for-new hide"><i class="aicon-plus aicon-align-middle"></i>&nbsp;&nbsp;Add New</span>';
			$html .= '<span class="for-list"><i class="aicon-close aicon-align-middle"></i>&nbsp;&nbsp;Cancel</span>';
			$html .= '</button>';
		}
		else
		{
			$html .= '<button type="button" class="btn btn-outline-secondary" onclick="return vpAddNewTheme(this);">';
			$html .= '<span class="for-new"><i class="aicon-plus aicon-align-middle"></i>&nbsp;&nbsp;Add New</span>';
			$html .= '<span class="for-list hide"><i class="aicon-close aicon-align-middle"></i>&nbsp;&nbsp;Cancel</span>';
			$html .= '</button>';
		}
		
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			$html .= '</div>';
		}
		
		return $html;
	}
	
	protected function getOptions()
	{
		$options = parent::getOptions();
		$helper  = VPFrameworkAdmin::getInstance();
		$themes  = $helper->getThemes();
		
		if (empty($themes))
		{
			return $options;
		}
		
		foreach ($themes as $theme)
		{
			$options[] = JHtml::_('select.option', $theme, ucfirst($theme));
		}
		
		return array_merge(parent::getOptions(), $options);
	}
}