<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

JLoader::register('VmConfig',        JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');
JLoader::register('ShopFunctions',   JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/shopfunctions.php');
JLoader::register('TableCategories', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/categories.php');

VmConfig::loadConfig();
VmConfig::loadJLang('com_virtuemart');

class JFormFieldVpvmcategories extends JFormFieldList
{
	protected static $_categories = null;
	
	public $type = 'vpvmcategories';

	public function getOptions()
	{
		if (self::$_categories === null)
		{
			if (!class_exists('VPFrameworkVM'))
			{
				require(JPATH_SITE . '/plugins/system/vpframework/helpers/vm.php');
			}
			
			self::$_categories = VPFrameworkVM::categoryListTree();
		}

		if (version_compare(JVERSION, '4.0.0', 'ge') && $this->multiple)
		{
			$this->layout = 'joomla.form.field.list-fancy-select';
		}

		return array_merge(parent::getOptions(), self::$_categories);
	}
}