<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2015 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          http://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

/**
* VP Framework Global
* 
* @since 1.0.0
*/
class VPFrameworkGlobal extends JObject
{
	protected $options;
	protected $states = array();
	protected $key = null;
	protected $stored = false;
	
	protected static $instances = array();
	
	public function __construct($options = array())
	{
		$this->options = $options;
		$this->loadStates();
	}
	
	public static function getInstance($options = array())
	{
		$options = (array) $options;
		$hash    = md5(serialize($options));

		if (!isset(self::$instances[$hash]))
		{
			self::$instances[$hash] = new VPFrameworkGlobal($options);
		}
		
		return self::$instances[$hash];
	}
	
	public function setState($name, $value)
	{
		$name = strval($name);
		$this->states[$name] = $value;
	}
	
	public function getState($name, $default)
	{
		if (isset($this->states[$name]))
		{
			return $this->states[$name];
		}
		
		return $default;
	}
	
	public function removeState($name)
	{
		if (isset($this->states[$name]))
		{
			unset($this->states[$name]);
		}
	}
	
	protected function loadStates()
	{
		$key = $this->getKey();
		
		if (!empty($key))
		{
			$cache  = JFactory::getCache('vp_framework_global', '');
			$output = $cache->get($key);
			
			if (!empty($output))
			{
				// Loaded from cache so we do not need to save cache
				$this->stored = true;
				$this->states = (array) $output;
			}
			else
			{
				$this->states = array();
			}
		}
	}
	
	
	// Call store cache after everything is printed.
	// See prepareBody function in main VP Framework helper
	public function storeStates()
	{
		if (!$this->stored)
		{
			if (!empty($this->states))
			{
				$key   = $this->getKey();
				$cache = JFactory::getCache('vp_framework_global', '');
				
				$cache->store($this->states, $key);
			}

			$this->stored = true;
		}
	}
	
	protected function getKey()
	{
		if ($this->key === null)
		{
			$this->key = 'vpframework.global.' . JUri::getInstance()->toString();
		}
		
		return $this->key;
	}
}