<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

class VPFrameworkOverrides
{
	public static function process()
	{
		$app         = JFactory::getApplication();
		$input       = $app->input;
		$option      = strtolower($input->getCmd('option'));
		$view        = strtolower($input->getCmd('view'));
		$id          = $input->getInt('id', 0);
		$task        = strtolower($input->getCmd('task', 'display'));
		
		if ($option == 'com_content' && $view == 'article' && $task == 'display')
		{
			$params      = plgSystemVPFrameworkHelper::getTemplate()->params;
			$cache_skips = array($params->get('compare_article_id', 0), $params->get('wishlist_article_id', 0));
			
			if (!empty($id) && in_array($id, $cache_skips) && $input->getMethod() == 'GET')
			{
				if (version_compare(JVERSION, '4.0.0', 'ge'))
				{
					if (!class_exists('Joomla\Component\Content\Site\Controller\DisplayController', false))
					{
						require(VPF_PLUGINPATH . '/controllers/com_content/DisplayController.php');
					}
				}
				elseif (!class_exists('ContentController', false))
				{
					require(VPF_PLUGINPATH . '/controllers/com_content/controller.php');
				}
			}
		}
	}
}