/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
 */
(function($) {
	$(document).ready(function() {

		$('.vp-product-carousel .btn-hover-addtocart').off('click');
		$('.vp-product-carousel .btn-hover-addtocart').on('click', function(e) {
			e.preventDefault();
			var form = $(this).closest('.product-item').find('form.js-recalculate');
			if($('a.btn-notify', form).length) {
				window.location.href = $('a.btn-notify', form).attr('href');
			} else if($('a.btn-options', form).length) {
				window.location.href = $('a.btn-options', form).attr('href');
			} else {
				$('input.btn-addtocart', form).trigger('click');
			}
			return false;
		});

		$(document).off('product.carousel.afterAction');
		$(document).on('product.carousel.afterAction', function() {

			if ($('.vp-product-carousel').length) {

				var equalHeightEnabled,
					lazyloadEnabled,
					$productCont,
					$productOuter;

				$('.vp-product-carousel').each(function() {

					equalHeightEnabled = $(this).hasClass('equal-height');
					lazyloadEnabled = $(this).hasClass('lazyload-enabled');
					$productCont = $('.product-inner:visible:not(.open)', this);
					$productOuter = $productCont.parents('.owl-stage-outer');

					// Fix VirtueMart input/button missing type attribute
					$('input', $productCont).each(function() {
						if (!$(this).attr('type')) {
							$(this).attr('type', 'button');
						}
					});

					// If Equal Height Enabled
					if ($.fn.equalHeight && equalHeightEnabled && $productCont.length) {
						$('.product-name-cont', $productCont).equalHeight({
							wait: false,
							responsive: true
						});
						$('.product-rating-cont:visible', $productCont).equalHeight({
							wait: false,
							responsive: true
						});
						$('.product-price-cont', $productCont).equalHeight({
							wait: false,
							responsive: true
						});
						$('.product-image-cont', $productCont).equalHeight({
							wait: false,
							responsive: true
						});
						$productCont.equalHeight({
							wait: false,
							responsive: true
						});
					}
					
					if($productCont.length) {
						var maxImageHeight = 0,
								imageHeight = 0;
						$('.product-image-cont', $productCont).each(function() {
							imageHeight = $(this).outerHeight();
							if(imageHeight > maxImageHeight) {
								maxImageHeight = imageHeight;
							}
						});
						
						if(maxImageHeight > 0) {
							var top = (maxImageHeight / 2) - ($('.owl-controls .owl-prev', this).outerHeight() / 2) + 10;
							$('.owl-controls .owl-prev, .owl-controls .owl-next', this).css('top', top);
						}
					}

				});

				// Product Mouse Over Effect
				function onProductCarouselMouseover() {
					var $productOuter = $(this).parents('.owl-wrapper-outer');
					var $productInner = $('.product-inner', this);
					var orgHeight = $productOuter.outerHeight();
					var marginBottom = $productOuter.pxVal('margin-bottom');
					$(this).addClass('over');
					$productInner.addClass('open');
					$('.display-on-mouseover', $productInner).each(function() {
						$(this).show();
						if ($(this).data('animate')) {
							$(this).addClass($(this).data('animate'));
						}
					});
					var newHeight = $productOuter.height();
					if (newHeight) {
						$productOuter.height(newHeight).css('margin-bottom', ((newHeight - orgHeight) - marginBottom) * -1);
					}

				};

				function onProductCarouselMouseout() {
					var $productOuter = $(this).parents('.owl-wrapper-outer');
					var $productInner = $('.product-inner', this);
					$('.display-on-mouseover', $productInner).each(function() {
						$(this).hide();
						if ($(this).data('animate')) {
							$(this).removeClass($(this).data('animate'));
						}
					});

					$productOuter.css('margin-bottom', '');
					$productOuter.css('height', '');

					if ($productInner.find('.btn-showvariants').length) {
						$productInner.find('.btn-showvariants').removeClass('hide');
						$productInner.find('.addtocart-button, .addtocart-button-disabled, .product-cart-variants').addClass('hide');
					}
					$(this).removeClass('over');
					$productInner.removeClass('open');
				};

				$('.vp-product-carousel-inner .product-item').hoverIntent({
					interval: 100,
					sensitivity: 10,
					over: onProductCarouselMouseover,
					timeout: 100,
					out: onProductCarouselMouseout
				});

				// Show Varients
				var $addtocartForm,
					$productOuter,
					orgHeight,
					marginBottom,
					newHeight;

				$('.vp-product-carousel-inner .btn-showvariants').off('click');
				$('.vp-product-carousel-inner .btn-showvariants').on('click', function(e) {
					e.preventDefault();
					$addtocartForm = $(this).parents('form');
					$productOuter = $(this).parents('.owl-wrapper-outer');
					orgHeight = $productOuter.height();
					$('.product-cart-variants', $addtocartForm).css('opacity', 0).removeClass('hide');
					$(this).addClass('hide').siblings('.addtocart-button, .addtocart-button-disabled').removeClass('hide');
					marginBottom = $productOuter.pxVal('margin-bottom');
					$productOuter.css('height', '');
					newHeight = $productOuter.height();
					if (newHeight > orgHeight) {
						$productOuter.height(newHeight).css('margin-bottom', ((newHeight - orgHeight) - marginBottom) * -1);
					}

					$('.product-cart-variants', $addtocartForm).animate({
						'opacity': 1
					}, 200);
					return false;
				});

			}
		});

		$(document).on('product.carousel.afterInit', function(e, slider, margin) {
			if (slider && slider.$owlItems.length) {
				margin = parseInt(margin);
				margin = Number(Math.round((margin / 2) + 'e4') + 'e-4');
				$('.product-item', slider.$owlItems).css({
					'margin-left': margin,
					'margin-right': margin
				});
				
				$('.vp-product-carousel').each(function() {
					if ($(this).siblings('.mod-badge').length && $('.owl-buttons', this).length) {
						$(this).siblings('.mod-badge').css({
							'right': $('.owl-buttons', this).width() + 10
						})
					}
				});
			}
		});

	});
})(jQuery);