<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$offcanvasAttribs     = array();
$offcanvasAttribs[]   = $this->params->get('offcanvas_slidingSubmenus', 1) ?
                        'data-sliding="true"' :
                        'data-sliding="false"';
$offcanvasClases      = (array) $this->params->get('offcanvas_effects', array('mm-slide'));
$offcanvasClases      = implode(' ', $offcanvasClases);
$offcanvasClases      = $this->params->get('offcanvas_theme', '') ?
                        $this->params->get('offcanvas_theme', '') . ' ' . $offcanvasClases :
                        $offcanvasClases;
$offcanvasClases      = $this->params->get('offcanvas_fullscreen', 0) ?
                        'mm-fullscreen ' . $offcanvasClases :
                        $offcanvasClases;
$offcanvasAttribs[]   = 'data-classes="' . $offcanvasClases . '"';
$offcanvasAttribs[]   = 'data-position="' . $this->params->get('offcanvas_position', 'left') . '"';
$offcanvasAttribs[]   = 'data-zposition="' . $this->params->get('offcanvas_zposition', 'back') . '"';
$offcanvasAttribs[]   = $this->params->get('offcanvas_counters', 1) ?
                        'data-counters="true"' :
                        'data-counters="false"';
$offcanvasAttribs[]   = $this->params->get('offcanvas_header_add', 1) ?
                        'data-header-add="true"' :
                        'data-header-add="false"';
$offcanvasHeaderTitle = $this->params->get('offcanvas_header_title', '') ?
                        JText::_(htmlspecialchars($this->params->get('offcanvas_header_title', ''), ENT_COMPAT, 'UTF-8', false)) :
                        '';
$offcanvasAttribs[]   = 'data-header-title="' . $offcanvasHeaderTitle . '"';
$offcanvasAttribs     = implode(' ', $offcanvasAttribs);
?>
<div id="vpf-offcanvas" class="nano" <?php echo $offcanvasAttribs ?>>
	<?php echo $template->getOffcanvas(); ?>
</div>
<?php if($this->countModules('offcanvas')) : ?>
	<div id="vpf-offcanvas-module" class="vpf-offcanvas-bottom hide">
		<jdoc:include type="modules" name="offcanvas" style="block"/>
	</div>
<?php endif; ?>