<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');

$template = plgSystemVPFrameworkHelper::getTemplate();
$doc      = JFactory::getDocument();
$lang     = JFactory::getLanguage();
$lang->load('plg_user_profile', JPATH_ADMINISTRATOR);

$doc->addScriptDeclaration("
  Joomla.twoFactorMethodChange = function(e) {
    var selectedPane = 'com_users_twofactor_' + jQuery('#jform_twofactor_method').val();
    jQuery.each(jQuery('#com_users_twofactor_forms_container>div'), function(i, el) {
      if (el.id != selectedPane) {
        jQuery('#' + el.id).addClass('hide').removeClass('show');
      } else {
        jQuery('#' + el.id).addClass('show').removeClass('hide');
      }
    });
  }
");
?>
<div class="narrow-container profile-edit<?php echo $this->pageclass_sfx?>">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>
	<div class="narrow-inner">
		<form id="member-profile" action="<?php echo JRoute::_('index.php?option=com_users&task=profile.save'); ?>" method="post" class="form-validate old-form" enctype="multipart/form-data">
			<?php foreach ($this->form->getFieldsets() as $group => $fieldset):// Iterate through the form fieldsets and display each one.?>
				<?php $fields = $this->form->getFieldset($group);?>
				<?php if (count($fields)):?>
				<fieldset>
					<?php if (isset($fieldset->label)): // If the fieldset has a label set, display it as the legend. ?>
						<legend><?php echo JText::_($fieldset->label); ?></legend>
					<?php endif;?>
					<?php if (isset($fieldset->description) && trim($fieldset->description)) : ?>
						<p><?php echo $this->escape(JText::_($fieldset->description)); ?></p>
					<?php endif; ?>
					<?php foreach ($fields as $field):// Iterate through the fields in the set and display them.?>
						<?php if (version_compare(JVERSION, '4.0.0', 'ge')) : ?>
							<?php echo $field->renderField(array('class' => 'form-group')); ?>
						<?php else : ?>
							<?php if ($field->hidden):// If the field is hidden, just display the input.?>
								<?php echo $field->input;?>
							<?php else:?>
								<div class="form-group">
									<?php echo $field->label; ?>
									<?php if($field->fieldname == 'helpsite')
									{
										echo '<div class="input-group">';
										echo str_replace('btn ', 'btn btn-default ', $field->input);
										echo '</div>';
									}
									else
									{
										echo $field->input;
									} ?>
								</div>
							<?php endif;?>
						<?php endif; ?>
					<?php endforeach;?>
				</fieldset>
				<?php endif;?>
			<?php endforeach;?>
			<?php if (!empty($this->twofactormethods) && count($this->twofactormethods) > 1): ?>
				<fieldset>
					<legend><?php echo JText::_('COM_USERS_PROFILE_TWO_FACTOR_AUTH') ?></legend>
					<div class="form-group">
						<?php $title = addslashes('<strong>' . JText::_('COM_USERS_PROFILE_TWOFACTOR_LABEL') . '</strong><br/>' . JText::_('COM_USERS_PROFILE_TWOFACTOR_DESC')) ; ?>
						<label id="jform_twofactor_method-lbl" for="jform_twofactor_method" class="control-label hasTooltip" title="<?php echo $title ?>">
							<?php echo JText::_('COM_USERS_PROFILE_TWOFACTOR_LABEL'); ?>
						</label>
						<?php echo JHtml::_('select.genericlist', $this->twofactormethods, 'jform[twofactor][method]', array('onchange' => 'Joomla.twoFactorMethodChange()'), 'value', 'text', $this->otpConfig->method, 'jform_twofactor_method', false) ?>
					</div>
					<div id="com_users_twofactor_forms_container">
						<?php foreach($this->twofactorform as $form): ?>
							<?php $class = $form['method'] == $this->otpConfig->method ? 'show' : 'hide'; ?>
							<div id="com_users_twofactor_<?php echo $form['method'] ?>" class="<?php echo $class; ?>">
								<?php echo $form['form'] ?>
							</div>
						<?php endforeach; ?>
					</div>
				</fieldset>
				<fieldset>
					<legend><?php echo JText::_('COM_USERS_PROFILE_OTEPS') ?></legend>
					<p class="bg-box bg-info"><?php echo JText::_('COM_USERS_PROFILE_OTEPS_DESC') ?></p>
					<?php if (empty($this->otpConfig->otep)): ?>
						<p class="bg-box bg-warning"><?php echo JText::_('COM_USERS_PROFILE_OTEPS_WAIT_DESC') ?></p>
					<?php else: ?>
						<div class="row">
							<?php foreach ($this->otpConfig->otep as $otep): ?>
								<div class="col-sm-3">
									<?php echo substr($otep, 0, 4) ?>-<?php echo substr($otep, 4, 4) ?>-<?php echo substr($otep, 8, 4) ?>-<?php echo substr($otep, 12, 4) ?>
								</div>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
				</fieldset>
			<?php endif; ?>
			<div class="form-group">
				<button type="submit" class="btn btn-base btn-lg validate"><span><?php echo JText::_('JSUBMIT'); ?></span></button>
				&nbsp;<a class="btn btn-default btn-lg" href="<?php echo JRoute::_('index.php?option=com_users&view=profile'); ?>" title="<?php echo JText::_('JCANCEL'); ?>"><?php echo JText::_('JCANCEL'); ?></a>
			</div>
			<input type="hidden" name="option" value="com_users" />
			<input type="hidden" name="task" value="profile.save" />
			<?php echo JHtml::_('form.token'); ?>
		</form>
	</div>
</div>
