<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined ('_JEXEC') or die('Restricted access');

if(!class_exists('ShopFunctions'))
{
	require(VMPATH_ADMIN . '/helpers/shopfunctions.php');
}

$totalCount = 0;

foreach($this->cart->products as $product)
{
	$totalCount += $product->quantity;
}

//JHtml::_('behavior.formvalidation');

if(VmConfig::get('oncheckout_ajax',false))
{
	vmJsApi::addJScript('updDynamicListeners', "
	if(typeof Virtuemart !== typeof undefined) {
		if (typeof Virtuemart.containerSelector === typeof undefined) {
			Virtuemart.containerSelector = '#cart-view';
		}
		if (typeof Virtuemart.container === typeof undefined) {
			Virtuemart.container = jQuery(Virtuemart.containerSelector);
		}
	}
	");
}

$updateFunction = '';

if(VmConfig::get('oncheckout_ajax', false))
{
	$updateFunction = 'Virtuemart.updForm();';
}

vmJsApi::addJScript('vm.checkoutFormSubmit', "
(function($) {
	$(document).off('bind.checkoutform').on('bind.checkoutform', function(e) {
		if(typeof Virtuemart !== typeof undefined) {
			if (typeof Virtuemart.containerSelector === typeof undefined) {
				Virtuemart.containerSelector = '#cart-view';
			}
			if (typeof Virtuemart.container === typeof undefined) {
				Virtuemart.container = $(Virtuemart.containerSelector);
			}
			if(Virtuemart.container.length && typeof Virtuemart.updDynFormListeners !== typeof undefined) {
				Virtuemart.updDynFormListeners();
			}
		}
		$('#checkoutFormSubmit').off('click').off('dblclick').on('click dblclick', function(a) {
			a.preventDefault();
			$(this).vm2front('startVmLoading');
			VPF.showVPFActivity();
			$(this).attr('disabled', true).removeClass('vm-button-correct').addClass('vm-button').fadeIn(400);
			var name = $(this).attr('name');
			$('form#checkoutForm').append('<input name=\"' + name + '\" value=\"1\" type=\"hidden\" />').submit();
		});
		$('#STsameAsBTjs').off('change.stasbt').on('change.stasbt', function(e) {
			var field = $('input[name=\"STsameAsBT\"]:hidden');
			if($(this).is(':checked')) {
				field.val(1);
			} else {
				field.val(0);
			}
			" . $updateFunction . "
			$('#checkoutForm').submit();
		});
	});
	$(function() {
		$(document).trigger('bind.checkoutform');
		$(document).on('vm.cartpage.loaded', function() {
			$(document).trigger('bind.checkoutform');
		});
	});

})(jQuery);
");

vmJsApi::addJScript('autocheck', "
(function($) {
	$(document).off('bind.autocheck').on('bind.autocheck', function(e) {
		$('.cart-address-content').find('input[type=\"radio\"]').on('change', function() {
			$('#checkoutFormSubmit').attr('task', 'checkout');
			" . $updateFunction . "
			$('#checkoutForm').submit();
		});
		$('#checkoutForm').change(function() {
			$('#checkoutFormSubmit').attr('name', 'checkout').html('" . vmText::_('COM_VIRTUEMART_CHECKOUT_TITLE') . "');
		});
		$('#checkoutForm .required').change(function() {
			var count = 0, hit = 0;
			$.each($('#checkoutForm .required'), function (key, value){
				count++;
				if($(this).is(':checked')) hit++;
			});
			if(count == hit) {
				$('#checkoutFormSubmit').attr('task', 'checkout');
				" . $updateFunction . "
				$('#checkoutForm').submit();
			}
		});
	});
	$(function() {
		$(document).trigger('bind.autocheck');
		$(document).on('vm.cartpage.loaded', function() {
			$(document).trigger('bind.autocheck');
		});
	});
})(jQuery);
");
?>
<section id="cart-view" class="cart-view">
	<div class="vm-cart-header-container">
		<div class="vm-cart-header">
			<h1>
				<span><?php echo vmText::_('COM_VIRTUEMART_CART_TITLE'); ?></span>
				<span class="septa">/</span>
				<span class="cart-product-count"><?php echo JText::sprintf('COM_VIRTUEMART_CART_X_PRODUCTS', $totalCount) ?></span>
			</h1>
			<div class="payments-signin-button"></div>
		</div>
		<?php if (VmConfig::get ('oncheckout_show_steps', 1) && $this->checkout_task === 'confirm') : ?>
			<div class="checkoutStep" id="checkoutStep4"><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_CART_STEP4') ?></div>
		<?php endif; ?>
	</div>
	
	<div class="cart-login-cont">
		<?php echo shopFunctionsF::getLoginForm($this->cart, false); ?>
	</div>
	
	<?php 
	// This displays the form to change the current shopper
	$adminID = JFactory::getSession()->get('vmAdminID');
	if ((JFactory::getUser()->authorise('core.admin', 'com_virtuemart') || JFactory::getUser($adminID)->authorise('core.admin', 'com_virtuemart')) && (VmConfig::get ('oncheckout_change_shopper', 0))) 
	{
		echo $this->loadTemplate('shopperform');
	}
	$taskRoute = '';
	?>
	<form method="post" id="checkoutForm" name="checkoutForm" action="<?php echo JRoute::_('index.php?option=com_virtuemart&view=cart' . $taskRoute, $this->useXHTML, $this->useSSL); ?>">
	
		<?php if(VmConfig::get('multixcart') == 'byselection') : ?>
			<?php echo shopFunctions::renderVendorFullVendorList($this->cart->vendorId); ?>
			<input type="submit" name="updatecart" title="<?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>" value="<?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>" class="btn btn-default" />
		<?php endif; ?>
		
		<?php echo $this->loadTemplate('address'); ?>
		
		<?php echo $this->loadTemplate('pricelist'); ?>

		<?php if(!empty($this->checkoutAdvertise)) : ?>
			<div id="checkout-advertise-box"> 
				<?php foreach($this->checkoutAdvertise as $checkoutAdvertise) : ?>
					<div class="checkout-advertise">
						<?php echo $checkoutAdvertise; ?>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>

		<?php echo $this->loadTemplate('cartfields'); ?>
		
		<div class="cart-submission-buttons-cont">
			<div class="row">
				<div class="col-sm-6 align-center-xs">
					<?php if(!empty($this->continue_link)) : ?>
						<a href="<?php echo $this->continue_link ?>" class="btn btn-invert btn-lg">
							<i class="fa fa-angle-left fa-lg"></i>&nbsp;&nbsp;<span><?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING') ?></span>
						</a>
					<?php endif; ?>
				</div>
				<div class="col-sm-6 align-right-sm align-center-xs">
					<?php
					if ($this->cart->getDataValidated()) 
					{
						if($this->cart->_inConfirm)
						{
							$text = vmText::_('COM_VIRTUEMART_CANCEL_CONFIRM');
						} 
						else 
						{
							$text = vmText::_('COM_VIRTUEMART_ORDER_CONFIRM_MNU');
						}
					} 
					else 
					{
						$text = vmText::_('COM_VIRTUEMART_CHECKOUT_TITLE');
					} ?>
					<button type="submit" id="checkoutFormSubmit" name="<?php echo $this->checkout_task ?>" value="1" class="btn btn-base btn-lg"><?php echo $text ?></button>
				</div>
			</div>
		</div>

		<input type="hidden" name="order_language" value="<?php echo $this->order_language; ?>" />
		<input type="hidden" name="task" value="updatecart" />
		<input type="hidden" name="option" value="com_virtuemart" />
		<input type="hidden" name="view" value="cart" />
	</form>

	<?php 
	// Write VirtueMart JS
	echo vmJsApi::writeJS(); ?>

</section>