<?php 
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$document = JFactory::getDocument();

// Derive Tax Column Title
$taxTitle = vmText::_ ('COM_VIRTUEMART_CART_SUBTOTAL_TAX_AMOUNT');

if (VmConfig::get ('show_tax') && !empty($this->cart->cartData['VatTax']) && count($this->cart->cartData['VatTax']) < 2)
{
	reset($this->cart->cartData['VatTax']);
	$taxd = current($this->cart->cartData['VatTax']);
	
	if (method_exists(shopFunctionsF::class, 'getTaxNameWithValue'))
	{
		$taxTitle = shopFunctionsF::getTaxNameWithValue(vmText::_($taxd['calc_name']), $taxd['calc_value']);
	}
	else
	{
		$taxTitle = vmText::_($taxd['calc_name']) . ' ' . rtrim(trim($taxd['calc_value'], '0'), '.') . '%';
	}
}

if (VmConfig::get('show_tax')) 
{ 
	$document->addStyleDeclaration("
		@media (max-width: 768px) {
			.cart-p-list td:nth-of-type(1):before { content: '".JText::_('COM_VIRTUEMART_CART_NAME')."'; }
			.cart-p-list td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SKU')."'; }
			.cart-p-list td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_PRICE')."'; }
			.cart-p-list td:nth-of-type(4):before { content: '".JText::_('COM_VIRTUEMART_CART_QUANTITY'). '/' .JText::_('COM_VIRTUEMART_CART_ACTION')."'; }
			.cart-p-list td:nth-of-type(5):before { content: '".$taxTitle."'; }
			.cart-p-list td:nth-of-type(6):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
			.cart-p-list td:nth-of-type(7):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			.cart-sub-total td:nth-of-type(1):before { content: ''; }
			.cart-sub-total td:nth-of-type(2):before { content: '".$taxTitle."'; }
			.cart-sub-total td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
			.cart-sub-total td:nth-of-type(4):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			.tax-per-bill td:nth-of-type(1):before { content: ''; }
			.tax-per-bill td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_TAX_AMOUNT')."'; }
			.tax-per-bill td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
			.tax-per-bill td:nth-of-type(4):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			.grand-total td:nth-of-type(1):before { content: ''; }
			.grand-total td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_TAX_AMOUNT')."'; }
			.grand-total td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
			.grand-total td:nth-of-type(4):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			.grand-total-p-currency td:nth-of-type(1):before { content: ''; }
			.grand-total-p-currency td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
		}
	");
	if (!empty($this->cart->cartData['couponCode'])) 
	{	
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.cart-coupon-row td:nth-of-type(1):before { content: ''; }
				.cart-coupon-row td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_TAX_AMOUNT')."'; }
				.cart-coupon-row td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
				.cart-coupon-row td:nth-of-type(4):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			}
		");
	} 
	else 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.cart-coupon-row td:nth-of-type(1):before { content: ''; }
				.cart-coupon-row td:nth-of-type(2) { display:none; }
				.cart-coupon-row td:nth-of-type(3) { display:none; }
				.cart-coupon-row td:nth-of-type(4) { display:none; }
			}
		");
	}
	if(!empty($this->cart->pricesUnformatted['salesPriceShipment'])) 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.shipping-row td:nth-of-type(1):before { content: ''; }
				.shipping-row td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_TAX_AMOUNT')."'; }
				.shipping-row td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
				.shipping-row td:nth-of-type(4):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			}
		");
	} 
	else 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.shipping-row td:nth-of-type(1):before { content: ''; }
				.shipping-row td:nth-of-type(2) { display:none; }
				.shipping-row td:nth-of-type(3) { display:none; }
				.shipping-row td:nth-of-type(4) { display:none; }
			}
		");
	}
	
	if(!empty($this->cart->pricesUnformatted['salesPricePayment'])) 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.payment-row td:nth-of-type(1):before { content: ''; }
				.payment-row td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_TAX_AMOUNT')."'; }
				.payment-row td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
				.payment-row td:nth-of-type(4):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			}
		");
	} 
	else 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.payment-row td:nth-of-type(1):before { content: ''; }
				.payment-row td:nth-of-type(2) { display:none; }
				.payment-row td:nth-of-type(3) { display:none; }
				.payment-row td:nth-of-type(4) { display:none; }
			}
		");
	}
} 
else 
{
	$document->addStyleDeclaration("
		@media (max-width: 768px) {
			.cart-p-list td:nth-of-type(1):before { content: '".JText::_('COM_VIRTUEMART_CART_NAME')."'; }
			.cart-p-list td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SKU')."'; }
			.cart-p-list td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_PRICE')."'; }
			.cart-p-list td:nth-of-type(4):before { content: '".JText::_('COM_VIRTUEMART_CART_QUANTITY'). '/' .JText::_('COM_VIRTUEMART_CART_ACTION')."'; }
			.cart-p-list td:nth-of-type(5):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
			.cart-p-list td:nth-of-type(6):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			.cart-sub-total td:nth-of-type(1):before { content: ''; }
			.cart-sub-total td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
			.cart-sub-total td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			.tax-per-bill td:nth-of-type(1):before { content: ''; }
			.tax-per-bill td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			.grand-total td:nth-of-type(1):before { content: ''; }
			.grand-total td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT')."'; }
			.grand-total td:nth-of-type(3):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			.grand-total-p-currency td:nth-of-type(1):before { content: ''; }
			.grand-total-p-currency td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
		}
	");
	if (!empty($this->cart->cartData['couponCode'])) 
	{	
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.cart-coupon-row td:nth-of-type(1):before { content: ''; }
				.cart-coupon-row td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			}
		");
	} 
	else 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.cart-coupon-row td:nth-of-type(1):before { content: ''; }
				.cart-coupon-row td:nth-of-type(2) { display:none; }
				.cart-coupon-row td:nth-of-type(3) { display:none; }
			}
		");
	}
	if(!empty($this->cart->pricesUnformatted['salesPriceShipment'])) 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.shipping-row td:nth-of-type(1):before { content: ''; }
				.shipping-row td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			}
		");	
	} 
	else 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.shipping-row td:nth-of-type(1):before { content: ''; }
				.shipping-row td:nth-of-type(2) { display:none; }
				.shipping-row td:nth-of-type(3) { display:none; }
			}
		");
	}
	
	if(!empty($this->cart->pricesUnformatted['salesPricePaymentt'])) 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.payment-row td:nth-of-type(1):before { content: ''; }
				.payment-row td:nth-of-type(2):before { content: '".JText::_('COM_VIRTUEMART_CART_TOTAL')."'; }
			}
		");
	} 
	else 
	{
		$document->addStyleDeclaration("
			@media (max-width: 768px) {
				.payment-row td:nth-of-type(1):before { content: ''; }
				.payment-row td:nth-of-type(2) { display:none; }
				.payment-row td:nth-of-type(3) { display:none; }
			}
		");
	}
}
?>
<fieldset class="vm-fieldset-pricelist">
	<table class="cart-summary table table-striped table-hover" >
		<thead>
			<tr>
				<th class="col-name align-left" align="left"><?php echo JText::_('COM_VIRTUEMART_CART_NAME') ?></th>
				<th class="col-sku align-left" align="left"><?php echo JText::_('COM_VIRTUEMART_CART_SKU') ?></th>
				<th class="col-price align-center" align="center"><?php echo JText::_('COM_VIRTUEMART_CART_PRICE') ?></th>
				<th class="col-qty align-center" align="center"><?php echo JText::_('COM_VIRTUEMART_CART_QUANTITY') ?> / <?php echo JText::_('COM_VIRTUEMART_CART_ACTION') ?></th>
				<?php if (VmConfig::get('show_tax')) : ?>
					<th class="col-tax align-right" align="right"><?php echo $taxTitle ?></th>
				<?php endif; ?>
				<th class="col-discount align-right" align="right"><?php echo JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT') ?></th>
				<th class="col-total align-right" align="right"><?php echo JText::_('COM_VIRTUEMART_CART_TOTAL') ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach( $this->cart->products as $pkey =>$prow ) { ?>
				<tr valign="top" class="cart-p-list">
					<td class="col-name" align="left" >
						<div class="cart-product-details clearfix<?php echo (VmConfig::get('oncheckout_show_images') && $prow->virtuemart_media_id) ? ' with-image' : ''; ?>">
							<?php if(VmConfig::get('oncheckout_show_images') && $prow->virtuemart_media_id) { ?>
									<div class="cart-product-image-cont">
										<?php if(!empty($prow->images[0])) echo JHTML::link($prow->url, $prow->images[0]->displayMediaThumb('class="img-thumbnail"', false)); ?>
									</div>
									<span class="cart-product-info">
										<?php echo JHTML::link($prow->url, $prow->product_name, 'class="cart-product-name hover-invert"') . $this->customfieldsModel->CustomsFieldCartDisplay($prow); ?>
									</span>
							<?php } else { 
								echo JHTML::link($prow->url, $prow->product_name, 'class="cart-product-name hover-invert"') . $this->customfieldsModel->CustomsFieldCartDisplay($prow); 
							}?>
						</div>
					</td>
					<td class="col-sku" align="left" ><?php  echo $prow->product_sku ?></td>
					<td class="col-price nowrap" align="center" >
						<?php if(VmConfig::get('checkout_show_origprice', 1) && $prow->prices['discountedPriceWithoutTax'] != $prow->prices['priceWithoutTax'])
						{
							echo '<s>' . $this->currencyDisplay->createPriceDiv('basePriceVariant', '', $prow->prices, true, false) . '</s><br />';
						}
						if($prow->prices['discountedPriceWithoutTax'])
						{
							echo $this->currencyDisplay->createPriceDiv('discountedPriceWithoutTax', '', $prow->prices, false, false);
						} 
						else
						{
							echo $this->currencyDisplay->createPriceDiv('basePriceVariant', '', $prow->prices, false, false);
						} ?>
					</td>
					<td class="col-qty cart-p-qty align-center" align="center" >
						<?php
						if ($prow->step_order_level)
							$step = $prow->step_order_level;
						else
							$step = 1;
						if($step == 0)
							$step = 1;
						?>
						<div class="form-inline">
							<input type="text" onblur="Virtuemart.checkQuantity(this,<?php echo $step?>,'<?php echo vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED')?>');" onclick="Virtuemart.checkQuantity(this,<?php echo $step?>,'<?php echo vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED')?>');" onchange="Virtuemart.checkQuantity(this,<?php echo $step?>,'<?php echo vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED')?>');" onsubmit="Virtuemart.checkQuantity(this,<?php echo $step?>,'<?php echo vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED')?>');" title="<?php echo  vmText::_('COM_VIRTUEMART_CART_UPDATE') ?>" class="quantity-input js-recalculate form-control" size="3" maxlength="4" name="quantity[<?php echo $pkey; ?>]" value="<?php echo $prow->quantity ?>" />
							<button type="submit" class="btn btn-transparent" name="updatecart.<?php echo $pkey ?>" title="<?php echo vmText::_('COM_VIRTUEMART_CART_UPDATE') ?>">
								<i class="fa fa-refresh fa-lg"></i><span class="sr-only"><?php echo vmText::_('COM_VIRTUEMART_CART_UPDATE') ?></span>
							</button>
							<button type="submit" class="btn btn-transparent" name="delete.<?php echo $pkey ?>" title="<?php echo vmText::_('COM_VIRTUEMART_CART_DELETE') ?>">
								<i class="fa fa-trash fa-lg"></i><span class="sr-only"><?php echo vmText::_('COM_VIRTUEMART_CART_DELETE') ?></span>
							</button>
						</div>
					</td>
					<?php if ( VmConfig::get('show_tax')) : ?>
						<td class="col-tax nowrap" align="right">
							<?php echo $this->currencyDisplay->createPriceDiv('taxAmount','', $this->cart->pricesUnformatted[$pkey], false, false, $prow->quantity) ?>
						</td>
					<?php endif; ?>
					<td class="col-discount nowrap" align="right">
						<?php echo $this->currencyDisplay->createPriceDiv('discountAmount','', $this->cart->pricesUnformatted[$pkey], false, false, $prow->quantity) ?>
					</td>
					<td class="col-total nowrap" colspan="1" align="right">
						<?php
						if (VmConfig::get ('checkout_show_origprice', 1) && !empty($prow->prices['basePriceWithTax']) && $prow->prices['basePriceWithTax'] != $prow->prices['salesPrice'])
						{
							echo '<s>' . $this->currencyDisplay->createPriceDiv ('basePriceWithTax', '', $prow->prices, true, false, $prow->quantity) . '</s><br />';
						}
						elseif (VmConfig::get ('checkout_show_origprice', 1) && empty($prow->prices['basePriceWithTax']) && $prow->prices['basePriceVariant'] != $prow->prices['salesPrice']) 
						{
							echo '<s>' . $this->currencyDisplay->createPriceDiv ('basePriceVariant', '', $prow->prices, true, false, $prow->quantity) . '</s><br />';
						}
						echo $this->currencyDisplay->createPriceDiv ('salesPrice', '', $prow->prices, false, false, $prow->quantity) ?>
					</td>
				</tr>
			<?php } ?>
		
			<!--Begin of SubTotal, Tax, Shipment, Coupon Discount and Total listing -->
			<?php $colspan = VmConfig::get('show_tax') ? 3 : 2; ?>
			<tr class="blank-row">
				<td colspan="4">&nbsp;</td>
				<td colspan="<?php echo $colspan ?>"></td>
			</tr>
			<tr class="cart-sub-total">
				<td class="sub-headings" colspan="4" align="right"><?php echo JText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_PRICES_TOTAL'); ?></td>
				<?php if ( VmConfig::get('show_tax')) { ?>
				<td class="col-tax nowrap" align="right"><?php echo $this->currencyDisplay->createPriceDiv('taxAmount','', $this->cart->pricesUnformatted,false)?></td>
				<?php } ?>
				<td class="col-discount nowrap" align="right"><?php echo $this->currencyDisplay->createPriceDiv('discountAmount','', $this->cart->pricesUnformatted,false) ?></td>
				<td class="col-total nowrap" align="right"><?php echo $this->currencyDisplay->createPriceDiv('salesPrice','', $this->cart->pricesUnformatted,false) ?></td>
			</tr>
		
			<?php if (VmConfig::get('coupons_enable')) : ?>
				<tr class="cart-coupon-row">
					<td class="coupon-form-col" colspan="4" align="left">
						<?php if(!empty($this->layoutName) && $this->layoutName == 'default') 
						{
							echo $this->loadTemplate('coupon');
						}
						if (!empty($this->cart->cartData['couponCode']))
						{
							echo '<span>'; 
							echo $this->cart->cartData['couponCode'] ;
							echo $this->cart->cartData['couponDescr'] ? (' (' . $this->cart->cartData['couponDescr'] . ')' ): '';
							echo '</span>';	
						} ?>
					</td>
					<?php if (!empty($this->cart->cartData['couponCode'])) {
						if (VmConfig::get('show_tax')) { ?>
							<td class="col-tax nowrap" align="right">
								<?php echo $this->currencyDisplay->createPriceDiv('couponTax', '', $this->cart->pricesUnformatted['couponTax'], false); ?> 
							</td>
						<?php } ?>
							<td colspan="2" class="col-total nowrap" align="right">
								<?php echo $this->currencyDisplay->createPriceDiv('salesPriceCoupon', '', $this->cart->pricesUnformatted['salesPriceCoupon'], false); ?> 
							</td>
						<?php } else { ?>
							<td colspan="6" align="left">&nbsp;</td>
						<?php } ?>
				</tr>
			<?php endif; ?>
		
			<?php foreach($this->cart->cartData['DBTaxRulesBill'] as $rule) : ?>
				<tr class="tax-per-bill DBTaxRulesBill">
					<td class="sub-headings" colspan="4" align="right">
						<?php echo $rule['calc_name'] ?>
					</td>
					<td class="col-tax nowrap" align="right"></td>
					<td class="col-discount nowrap" align="right">
						<?php echo $this->currencyDisplay->createPriceDiv($rule['virtuemart_calc_id'].'Diff','', $this->cart->pricesUnformatted[$rule['virtuemart_calc_id'].'Diff'], false); ?>
					</td>
					<td class="col-total nowrap" align="right">
						<?php echo $this->currencyDisplay->createPriceDiv($rule['virtuemart_calc_id'].'Diff','', $this->cart->pricesUnformatted[$rule['virtuemart_calc_id'].'Diff'], false); ?>
					</td>
				</tr>
			<?php endforeach; ?> 
		
			<?php foreach($this->cart->cartData['taxRulesBill'] as $rule) : ?>
				<tr class="tax-per-bill taxRulesBill">
					<td class="sub-headings" colspan="4" align="right">
						<?php echo $rule['calc_name'] ?>
					</td>
					<?php if (VmConfig::get('show_tax')) : ?>
						<td class="col-tax nowrap" align="right">
							<?php echo $this->currencyDisplay->createPriceDiv($rule['virtuemart_calc_id'].'Diff','', $this->cart->pricesUnformatted[$rule['virtuemart_calc_id'].'Diff'],false); ?>
						</td>
					<?php endif; ?>
					<td colspan="2" class="col-total nowrap" align="right">
						<?php echo $this->currencyDisplay->createPriceDiv($rule['virtuemart_calc_id'].'Diff','', $this->cart->pricesUnformatted[$rule['virtuemart_calc_id'].'Diff'],false); ?>
					</td>
				</tr>
			<?php endforeach; ?>

			<?php foreach($this->cart->cartData['DATaxRulesBill'] as $rule) : ?>
				<tr class="tax-per-bill DATaxRulesBill">
					<td class="sub-headings" colspan="4" align="right">
						<?php echo $rule['calc_name'] ?>
					</td>
					<td class="col-tax nowrap" align="right"></td>
					<td class="col-discount nowrap" align="right">
						<?php echo $this->currencyDisplay->createPriceDiv($rule['virtuemart_calc_id'].'Diff','', $this->cart->pricesUnformatted[$rule['virtuemart_calc_id'].'Diff'], false); ?>
					</td>		
					<td class="col-total nowrap" align="right">
						<?php echo $this->currencyDisplay->createPriceDiv($rule['virtuemart_calc_id'].'Diff','', $this->cart->pricesUnformatted[$rule['virtuemart_calc_id'].'Diff'], false); ?>
					</td>
				</tr>
			<?php endforeach; ?>

			<?php if (VmConfig::get('oncheckout_opc',true) || !VmConfig::get('oncheckout_show_steps',false) || (!VmConfig::get('oncheckout_opc',true) && VmConfig::get('oncheckout_show_steps',false) && !empty($this->cart->virtuemart_shipmentmethod_id))) : ?>
				<tr class="shipping-row" valign="top">
					<?php if (!$this->cart->automaticSelectedShipment) : ?>
						<td class="shipping-payment-heading" colspan="4" align="left">
							<div class="cart-shipment-name">
								<span<?php echo empty($this->cart->virtuemart_shipmentmethod_id) ? ' class="text-warning"' : ''; ?>><?php echo $this->cart->cartData['shipmentName']; ?></span>
							</div>
							<?php
							if (!empty($this->layoutName) and $this->layoutName == 'default') 
							{
								if (VmConfig::get('oncheckout_opc', 0)) 
								{
									$previouslayout = $this->setLayout('select');
									echo $this->loadTemplate('shipment');
									$this->setLayout($previouslayout);
								} 
								else 
								{
									echo JHtml::_('link', JRoute::_('index.php?option=com_virtuemart&view=cart&task=edit_shipment', $this->useXHTML, $this->useSSL), '<i class="icon-checkmark2"></i> ' . $this->select_shipment_text, 'class="btn btn-default btn-sm"');
								}
							} 
							else 
							{
								echo vmText::_('COM_VIRTUEMART_CART_SHIPPING');
							} ?>
						</td>
					<?php else : ?>
						<td class="shipping-payment-heading" colspan="4" align="left">
							<?php echo $this->cart->cartData['shipmentName']; ?>
						</td>
					<?php endif; ?>
					<?php if (VmConfig::get ('show_tax')) : ?>
						<td class="col-tax align-right nowrap" align="right" >
							<?php echo $this->currencyDisplay->createPriceDiv ('shipmentTax', '', $this->cart->cartPrices['shipmentTax'], false); ?>				
						</td>
					<?php endif; ?>
					<td class="col-discount align-right nowrap" align="right">
						<?php echo ($this->cart->cartPrices['salesPriceShipment'] < 0) ? $this->currencyDisplay->createPriceDiv ('salesPriceShipment', '', $this->cart->cartPrices['salesPriceShipment'], false) : ''; ?>			
					</td>
					<td class="col-total align-right nowrap" align="right">
						<?php echo $this->currencyDisplay->createPriceDiv ('salesPriceShipment', '', $this->cart->cartPrices['salesPriceShipment'], false); ?>
					</td>
				</tr>
			<?php endif; ?>

			<?php if($this->cart->pricesUnformatted['salesPrice'] > 0.0 && (VmConfig::get('oncheckout_opc', true) || !VmConfig::get('oncheckout_show_steps',false) || ((!VmConfig::get('oncheckout_opc',true) && VmConfig::get('oncheckout_show_steps',false)) && !empty($this->cart->virtuemart_paymentmethod_id)))) : ?>
				<tr class="payment-row"  valign="top">
					<td class="shipping-payment-heading" colspan="4" align="left">
						<?php if(!$this->cart->automaticSelectedPayment) : ?>
							<div class="cart-payment-name">
								<span<?php echo empty($this->cart->virtuemart_paymentmethod_id) ? ' class="text-warning"' : ''; ?>><?php echo $this->cart->cartData['paymentName']; ?></span>
							</div>
							<?php if(!empty($this->layoutName) && $this->layoutName == 'default') 
							{
								if (VmConfig::get('oncheckout_opc', 0)) 
								{
									$previouslayout = $this->setLayout('select');
									echo $this->loadTemplate('payment');
									$this->setLayout($previouslayout);
								} 
								else 
								{
									echo JHtml::_('link', JRoute::_('index.php?option=com_virtuemart&view=cart&task=editpayment', $this->useXHTML, $this->useSSL), '<i class="icon-checkmark2"></i> ' . $this->select_payment_text, 'class="btn btn-default btn-sm"');
								}
							} 
							else 
							{
								echo vmText::_('COM_VIRTUEMART_CART_PAYMENT');
							} 
						else :
							echo $this->cart->cartData['paymentName']; 
						endif; ?>
					</td>
					<?php if(VmConfig::get ('show_tax')) : ?>
						<td class="col-tax align-right nowrap" align="right">
							<?php echo $this->currencyDisplay->createPriceDiv ('paymentTax', '', $this->cart->cartPrices['paymentTax'], false); ?>
						</td>
					<?php endif; ?>
					<td class="col-discount align-right nowrap" align="right">
						<?php echo ($this->cart->cartPrices['salesPricePayment'] < 0) ? $this->currencyDisplay->createPriceDiv ('salesPricePayment', '', $this->cart->cartPrices['salesPricePayment'], false) : ''; ?>
					</td>
					<td class="col-total align-right nowrap" align="right">
						<?php  echo $this->currencyDisplay->createPriceDiv ('salesPricePayment', '', $this->cart->cartPrices['salesPricePayment'], false); ?>
					</td>
				</tr>
			<?php endif; ?>
		
			<tr class="blank-row">
				<td colspan="4">&nbsp;</td>
				<td colspan="<?php echo $colspan ?>"></td>
			</tr>

			<tr class="grand-total">
				<td class="sub-headings" colspan="4" align="right">
					<?php echo JText::_('COM_VIRTUEMART_CART_TOTAL') ?>:
				</td>
				<?php if(VmConfig::get('show_tax')) : ?>
					<td class="col-tax nowrap" align="right">
						<?php echo $this->currencyDisplay->createPriceDiv('billTaxAmount','', $this->cart->pricesUnformatted['billTaxAmount'], false) ?>
					</td>
				<?php endif; ?>
				<td class="col-discount nowrap" align="right">
					<?php echo $this->currencyDisplay->createPriceDiv('billDiscountAmount','', $this->cart->pricesUnformatted['billDiscountAmount'],false) ?>
				</td>
				<td class="col-total nowrap" align="right">
					<?php echo $this->currencyDisplay->createPriceDiv('billTotal','', $this->cart->pricesUnformatted['billTotal'],false); ?>
				</td>
			</tr>

			<?php if($this->totalInPaymentCurrency) : ?>
				<tr class="grand-total-p-currency">
					<td class="sub-headings" colspan="4" align="right">
						<?php echo JText::_('COM_VIRTUEMART_CART_TOTAL_PAYMENT') ?>:
					</td>
					<td class="col-total nowrap" colspan="<?php echo VmConfig::get('show_tax') ? 3 : 2; ?>" align="right">
						<span class="PricesalesPrice"><?php echo $this->totalInPaymentCurrency; ?></span>
					</td>
				</tr>
			<?php endif; ?>
			
			<?php if(!empty($this->cart->cartData) && !empty($this->cart->cartData['VatTax'])) : ?>
				<tr class="blank-row visible-xs">
					<td colspan="4">&nbsp;</td>
					<td colspan="<?php echo $colspan ?>"></td>
				</tr>
				<?php $vatCount = count($this->cart->cartData['VatTax']); ?>
				<?php if(!VmConfig::get('show_tax') || $vatCount > 1) : ?>
					<?php if($vatCount > 0) : ?>
						<tr class="vatTax-header">
							<td class="sub-headings" colspan="4" align="right">
								<strong><?php echo vmText::_ ('COM_VIRTUEMART_TOTAL_INCL_TAX') ?></strong>
							</td>
							<td colspan="<?php echo VmConfig::get('show_tax') ? 3 : 2; ?>" class="hidden-xs">&nbsp;</td>
						</tr>
					<?php endif; ?>
					<?php $i = 0; ?>
					<?php foreach($this->cart->cartData['VatTax'] as $vatTax) : ?>
						<?php if(!empty($vatTax['taxAmount']) || !empty($vatTax['result'])) : ?>
							<?php
							$i++;
							$amount = $vatTax['taxAmount'];

							if(!empty($vatTax['shipmentTax']))
							{
								$amount += $vatTax['shipmentTax'];
							}

							if(!empty($vatTax['paymentTax']))
							{
								$amount += $vatTax['paymentTax'];
							}

							if (method_exists(shopFunctionsF::class, 'getTaxNameWithValue'))
							{
								$vatTaxTitle = shopFunctionsF::getTaxNameWithValue(vmText::_($vatTax['calc_name']), $vatTax['calc_value']);
							}
							else
							{
								$vatTaxTitle = vmText::_($vatTax['calc_name']) . ' ' . rtrim(trim($vatTax['calc_value'], '0'), '.') . '%';
							}
							$document->addStyleDeclaration("
								@media (max-width: 768px) {
									.cart-summary.table tr.vatTax-row-" . $i . " { border-top: 0; }
									tr.vatTax-row-" . $i . " td.vattax-amount:before { content: '" . $vatTaxTitle . "'; }
								}
							"); ?>
							<tr class="vatTax-row-<?php echo $i ?>">
								<td class="vatTax-heading hidden-xs" colspan="4" align="right">
									<?php echo $vatTaxTitle; ?>
								</td>
								<?php if(VmConfig::get('show_tax')) : ?>
									<td class="col-tax vattax-amount nowrap" align="right">
										<?php echo $this->currencyDisplay->createPriceDiv('taxAmount', '', isset($vatTax['result']) ? $vatTax['result'] : $amount, false); ?>
									</td>
									<td colspan="2" class="hidden-xs">&nbsp;</td>
								<?php else : ?>
									<td class="hidden-xs">&nbsp;</td>
									<td class="col-total vattax-amount nowrap" align="right">
										<?php echo $this->currencyDisplay->createPriceDiv('taxAmount', '', isset($vatTax['result']) ? $vatTax['result'] : $amount, false); ?>
									</td>
								<?php endif; ?>
							</tr>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>
			<?php endif; ?>
			
		</tbody>
	</table>
</fieldset>