<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');
if (!class_exists ('VirtueMartModelUser')) 
{
	require(VMPATH_ADMIN . '/models/user.php');
}
$userList = $this->getUserList();
$currentUser = $this->cart->user->virtuemart_user_id;
$adminID = JFactory::getSession()->get('vmAdminID');
$instance = JFactory::getUser();
$select_list = JHtml::_('select.genericlist', $userList, 'userID', 'class="form-control"', 'id', 'displayedName', $currentUser);
?>
<div class="cart-shopper-selection-cont">
	<h3 class="cart-change-shopper-title"><?php echo vmText::_('COM_VIRTUEMART_CART_CHANGE_SHOPPER'); ?></h3>
	<form action="<?php echo JRoute::_ ('index.php'); ?>" method="post" class="form-inline">
		<div class="form-group">
			<label class="sr-only" for="exampleInputAmount"><?php echo vmText::_('COM_VIRTUEMART_CART_CHANGE_SHOPPER'); ?></label>
			<?php if(isset($adminID) && $instance->id != $adminID) : ?>
				<div class="input-group">
					<?php echo $select_list; ?>
					<div class="input-group-addon"><?php echo vmText::_('COM_VIRTUEMART_CART_ACTIVE_ADMIN') . ' '. JFactory::getUser($adminID)->name; ?></div>
				</div>
			<?php else : ?>
				<?php echo $select_list; ?>
			<?php endif; ?>
		</div>
		<button type="submit" name="changeShopper" title="<?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>" class="btn btn-default"><?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?></button>				
		<input type="hidden" name="view" value="cart"/>
		<input type="hidden" name="task" value="changeShopper"/>
		<?php echo JHtml::_( 'form.token' ); ?>
	</form>
</div>