<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$app                = JFactory::getApplication();
$option             = $app->input->getCmd('option');
$view               = $app->input->getCmd('view');
$_template          = plgSystemVPFrameworkHelper::getTemplate();
$showMfgFilter      = false;
$limitBox           = !empty($this->vmPagination) ? $this->vmPagination->getLimitBox($this->category->limit_list_step) : '';
$limitBox           = !empty($limitBox) ? VPFrameworkVM::getLimitBoxInfo($limitBox) : '';
$pagination         = !empty($this->vmPagination) ? $this->vmPagination->getPagesLinks() : '';
$pageCounter        = !empty($this->vmPagination) ? $this->vmPagination->getPagesCounter() : '';
$manufacturer_id    = $app->input->getInt('virtuemart_manufacturer_id', 0);
$categories_per_row = !empty($this->categories_per_row) ? $this->categories_per_row : VmConfig::get('categories_per_row', 3);

if(JModuleHelper::isEnabled('vp_custom_filter'))
{
	// No need to show manufacturer filter when we Filter module is enabled
	$_template->params->set('show_vm_mfg_filter', 0);
}

if($option == 'com_customfilters' && $view == 'products')
{
	$productsLayout = $app->getUserState('vpframework.vm.productsublayout.category.customfilters', 0);
	$viewMode       = strtolower($app->input->get('viewmode', null, 'WORD'));
	$modeMap        = array(
		'grid' => 'products',
		'list' => 'products_horizon'
	);
	$productsLayout = $viewMode && isset($modeMap[$viewMode]) ? $modeMap[$viewMode] : $productsLayout;
	$this->productsLayout = !empty($productsLayout) && in_array($productsLayout, $modeMap, true) ? $productsLayout : $this->productsLayout;
}

$hasProducts = (!empty($this->products['featured']) || !empty($this->products['latest']) || !empty($this->products['topten']) ||
               !empty($this->products['recent']) || !empty($this->products['discontinued']) || !empty($this->products['products'])) || 
               (empty($this->fallback) && !empty($this->products[0])) ||
               (!empty($this->products) && isset($this->products[0]) && isset($this->products[0]->virtuemart_product_id));
$hasFilter   = $_template->params->get('vm_collapse_left_postion', 1) && (JModuleHelper::getModules('left') || JModuleHelper::getModules('right'));
?>
<section class="category-view">
	<?php if(!empty($this->show_store_desc) && !empty($this->vendor->vendor_store_desc)) : ?>
		<div class="vendor-store-desc">
			<?php echo $this->vendor->vendor_store_desc; ?>
		</div>
	<?php endif; ?>
	
	<?php if(empty($this->keyword) && !empty($this->category) && !empty($this->category->category_description)) : ?>
		<div class="category-desc-cont">
			<?php echo $this->category->category_description; ?>
		</div>
	<?php endif; ?>
	
	<?php if(VmConfig::get('showCategory', 1) && empty($this->keyword) && empty($manufacturer_id) && !empty($this->category->haschildren)) : ?>
		<?php echo ShopFunctionsF::renderVmSubLayout('categories',array('categories'=>$this->category->children, 'categories_per_row' => $categories_per_row)); ?>
	<?php endif; ?>
	
	<div class="browse-view">
		<?php if(!empty($this->category->category_name) && (!empty($this->products) || !empty($manufacturer_id) || empty($this->category->haschildren) || !empty($this->keyword))) : ?>
			<?php if($_template->showPageHeadingInBreadcrumbs()) : ?>
				<?php $_template->setPageHeading($this->category->category_name); ?>
			<?php else : ?>
				<h1 class="category-page-title"><?php echo $this->category->category_name; ?></h1>
			<?php endif; ?>
		<?php elseif($_template->showPageHeadingInBreadcrumbs()) : ?>
			<?php $_template->setPageHeading($this->category->category_name); ?>
		<?php endif; ?>
		
		<?php if(!empty($this->keyword)) : ?>
			<h2 class="category-page-keyword"><?php echo $this->keyword; ?></h2>
			<div class="category-search-cont">
				<form action="<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=category&limitstart=0', false); ?>" method="get" role="form">
					<?php if(!empty($this->searchcustom) || !empty($this->searchCustomValues)) : ?>
						<div class="row">
							<?php if(!empty($this->searchcustom)) : ?>
								<div class="col-md-6">
									<?php echo $this->searchcustom ?>
								</div>
							<?php endif; ?>
							<?php if(!empty($this->searchCustomValues)) : ?>
								<div class="col-md-6">
									<?php echo $this->searchCustomValues ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<div class="input-group">
						<input name="keyword" class="form-control" type="text" size="20" value="<?php echo $this->keyword ?>" placeholder="<?php echo JText::_('JSEARCH_FILTER_SUBMIT') ?>..." />
						<div class="input-group-btn">
							<button type="submit" class="btn btn-default" onclick="this.form.keyword.focus();"><?php echo vmText::_('COM_VIRTUEMART_SEARCH') ?></button>
						</div>
					</div>
					<input type="hidden" name="search" value="true"/>
					<input type="hidden" name="view" value="category"/>
					<input type="hidden" name="option" value="com_virtuemart"/>
					<input type="hidden" name="virtuemart_category_id" value="<?php echo $this->categoryId; ?>" />
				</form>
			</div>
		<?php endif; ?>
		
		<?php if(!empty($this->products) && $hasProducts && !empty($this->orderByList)) : ?>
			<div class="toolbar">
				<div class="toolbar-inner clearfix">
					<span class="productlist-result hidden-xs hidden-sm"><?php echo $this->vmPagination->getResultsCounter(); ?></span>
					<?php if($hasFilter) : ?>
						<span class="product-filter hidden-md hidden-lg">
							<button type="button" class="btn btn-default btn-modpos-collapse hidden-md hidden-lg">
								<i class="fa fa-bars"></i>&nbsp;&nbsp;<?php echo JText::_('TPL_VP_SMART_MOD_COLLAPSE_BTN_TEXT_LEFT'); ?></button>
						</span>
					<?php endif; ?>
					<?php if($_template->params->get('show_vm_ordering', 1) || $_template->params->get('show_vm_mfg_filter', 1)) : ?>
					
						<?php if($_template->params->get('show_vm_ordering', 1)) : ?>
							<?php $orderBy = VPFrameworkVM::getOrderByInfo($this->orderByList['orderby']); ?>
							<?php if($orderBy && !empty($orderBy->options)) : ?>
								<span class="category-order-by<?php echo $hasFilter ? '' : ' no-border-mobile'; ?>">
									<label for="product_orderby"><?php echo vmText::_ ('COM_VIRTUEMART_ORDERBY') ?></label>
									<?php echo JHtml::_('select.genericlist', $orderBy->options, 'product_orderby', 'onchange="document.location.replace(this.value);" class="form-control selectpicker" data-dropup-auto="false"', 'value', 'text', $orderBy->selected, 'product_orderby'); ?>
									<a href="<?php echo $orderBy->dir_url; ?>" class="btn btn-switch" title="<?php echo $orderBy->dir_title; ?>">
										<?php if($orderBy->dir == 'asc') : ?>
											<span class="fa fa-arrow-up"></span>
										<?php else : ?>
											<span class="fa fa-arrow-down"></span>
										<?php endif; ?>
									</a>
								</span>
							<?php endif; ?>
						<?php endif; ?>
						
						<?php if($_template->params->get('show_vm_mfg_filter', 1)) : ?>
							<?php $mfgFilter = VPFrameworkVM::getManufactuerFilterInfo($this->orderByList['manufacturer']); ?>
							<?php if($mfgFilter && !empty($mfgFilter->options)) : ?>
							<?php $showMfgFilter = true; ?>
							<span class="category-mfg-filter hidden-xs">
								<label for="mfg_filter"><?php echo str_replace(':', '', vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS_MANUFACTURER_LBL')) ?></label>
								<?php echo JHtml::_('select.genericlist', $mfgFilter->options, 'mfg_filter', 'onchange="document.location.replace(this.value);" class="form-control selectpicker" data-dropup-auto="false"', 'value', 'text', $mfgFilter->selected, 'mfg_filter'); ?>
							</span>
							<?php endif; ?>
						<?php endif; ?>
						
						<?php if($_template->params->get('show_vm_list_switch', 1) && ($switches = VPFrameworkVM::getSwitches())) : ?>
							<span class="category-list-swicthes<?php echo $hasFilter ? ' hide-mobile' : ''; ?>">
								<span class="view-mode-title hidden-xs"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_VIEW_MODE_LABEL') ?>:</span>
								<?php if($switches['grid']->active) : ?>
									<span class="btn btn-switch active hasTooltip" title="<?php echo $switches['grid']->title ?>"><span class="fa fa-th"></span></span>
								<?php else : ?>
									<a class="btn btn-switch hasTooltip" href="<?php echo $switches['grid']->url; ?>" title="<?php echo $switches['grid']->title ?>"><span class="fa fa-th"></span></a>
								<?php endif; ?>
								<?php if($switches['list']->active) : ?>
									<span class="btn btn-switch active hasTooltip" title="<?php echo $switches['list']->title ?>"><span class="fa fa-th-list"></span></span>
								<?php else : ?>
									<a class="btn btn-switch hasTooltip" href="<?php echo $switches['list']->url; ?>" title="<?php echo $switches['list']->title ?>"><span class="fa fa-th-list"></span></a>
								<?php endif; ?>
							</span>
						<?php endif; ?>
						
						<?php if(!$showMfgFilter && !empty($limitBox)) : ?>
							<span class="category-result-counter pull-right hidden-xs">
								<label for="product_list_limitbox"><?php echo vmText::_('PLG_SYSTEM_VPFRAMEWORK_LIMITBOX_LABEL'); ?></label>
								<?php echo JHtml::_('select.genericlist', $limitBox->options, 'product_list_limitbox', 'onchange="document.location.replace(this.value);" class="form-control selectpicker"', 'value', 'text', $limitBox->selected, 'product_list_limitbox'); ?>
								<span><?php echo vmText::_('PLG_SYSTEM_VPFRAMEWORK_LIMITBOX_SUFFIX'); ?></span>
							</span>
						<?php endif; ?>
					<?php endif; ?>
				</div>
			</div>
		<?php endif; ?>
		
		<?php if(!empty($this->products) && $hasProducts) : ?>
			
			<?php if(!empty($pagination) || !empty($pageCounter)) : ?>
				<div class="paginaton-cont top-pagination hidden-xs">
					<div class="row row-condensed">
						<div class="col-sm-3">
							<div class="pagination-counter-limit-cont">
								<span class="page-counter text-muted"><?php echo $pageCounter ?></span>
								<?php if($showMfgFilter && !empty($limitBox)) : ?>
									&nbsp;
									<span class="category-result-counter hidden-xs">
										<label for="product_list_limitbox"><?php echo vmText::_('PLG_SYSTEM_VPFRAMEWORK_LIMITBOX_LABEL'); ?></label>
										<?php echo JHtml::_('select.genericlist', $limitBox->options, 'product_list_limitbox', 'onchange="document.location.replace(this.value);" class="form-control selectpicker"', 'value', 'text', $limitBox->selected, 'product_list_limitbox'); ?>
										<span><?php echo vmText::_('PLG_SYSTEM_VPFRAMEWORK_LIMITBOX_SUFFIX'); ?></span>
									</span>
								<?php else : ?>
									<div class="btn-group bootstrap-select form-control">
										&nbsp;
									</div>
								<?php endif; ?>
							</div>
						</div>
						<div class="col-sm-9 align-right align-center-xs">
							<?php echo $pagination ?>
						</div>
					</div>
				</div>
			<?php endif; ?>
			
			<?php 
			// Display product list
			if(isset($this->products['featured']) || isset($this->products['latest']) || isset($this->products['topten']) || isset($this->products['recent']) || isset($this->products['discontinued']))
			{
				$position = 0;
				
				foreach($this->products as $pType => $products)
				{
					if(empty($products))
					{
						continue;
					}
					
					if(!empty($pType) || count($this->products) > 1)
					{
						$position++;
						
						echo '<h4 class="section-header section-header-' . $pType . ' section-header-' . $position . '">' . JText::_('COM_VIRTUEMART_' . strtoupper($pType) . '_PRODUCT') . '</h4>';
					}
					
					$viewData = array('products' => $products, 'currency' => $this->currency, 'products_per_row' => $this->perRow, 'showRating' => $this->showRating);
					echo shopFunctionsF::renderVmSubLayout($this->productsLayout, $viewData);
				}
			}
			elseif(empty($this->fallback) && !empty($this->products[0]))
			{
				$viewData = array('products' => $this->products[0], 'currency' => $this->currency, 'products_per_row' => $this->perRow, 'showRating' => $this->showRating);
				echo shopFunctionsF::renderVmSubLayout($this->productsLayout, $viewData);
			}
			else
			{
				$products = isset($this->products['products']) ? $this->products['products'] : $this->products;
				$viewData = array('products' => $this->products, 'currency' => $this->currency, 'products_per_row' => $this->perRow, 'showRating' => $this->showRating);
				echo shopFunctionsF::renderVmSubLayout($this->productsLayout, $viewData);
			}
			?>

			<?php if(!empty($pagination) || !empty($pageCounter)) : ?>
				<div class="paginaton-cont">
					<div class="row row-condensed">
						<div class="col-sm-3">
							<div class="pagination-counter-limit-cont align-center-xs">
								<span class="page-counter text-muted"><?php echo $pageCounter ?></span>
								<?php if($showMfgFilter && !empty($limitBox)) : ?>
									&nbsp;
									<span class="category-result-counter hidden-xs">
										<label for="product_list_limitbox"><?php echo vmText::_('PLG_SYSTEM_VPFRAMEWORK_LIMITBOX_LABEL'); ?></label>
										<?php echo JHtml::_('select.genericlist', $limitBox->options, 'product_list_limitbox', 'onchange="document.location.replace(this.value);" class="form-control selectpicker"', 'value', 'text', $limitBox->selected, 'product_list_limitbox'); ?>
										<span><?php echo vmText::_('PLG_SYSTEM_VPFRAMEWORK_LIMITBOX_SUFFIX'); ?></span>
									</span>
								<?php else : ?>
									<div class="btn-group bootstrap-select form-control">
										&nbsp;
									</div>
								<?php endif; ?>
							</div>
						</div>
						<div class="col-sm-9 align-right align-center-xs">
							<?php echo $pagination ?>
						</div>
					</div>
				</div>
			<?php endif; ?>

		<?php elseif(!empty($this->keyword)) : ?>
			<p class="category-search empty-list"><?php echo vmText::_ ('COM_VIRTUEMART_NO_RESULT') . ($this->keyword ? ' : (' . $this->keyword . ')' : ''); ?></p>
		<?php elseif(empty($this->category->haschildren) || !empty($manufacturer_id)) : ?>
			<p class="category-search bg-box bg-warning"><?php echo vmText::_ ('COM_VIRTUEMART_NO_RESULT'); ?></p>
		<?php endif; ?>
		
	</div>
</section>