<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

vmJsApi::jPrice();
?>
<div class="product-comparison-page">
	<?php if(empty($this->cproducts)) : ?>
		<p class="empty-list"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_PRODUCT_EMPTY') ?></p>
	<?php else : ?>
		<?php
		$params = $this->params;
		$maxProducts = (int) $params->get('maxCompare', 3);
		$width = floor(12/$maxProducts);
		$class = 'col-xs-12 col-sm-' . $width;
		?>
		<div class="compare-clear-button-cont clearfix">
			<form name="comparisonClear" method="post" action="<?php echo JRoute::_('index.php?option=com_ajax&plugin=vpframework&format=raw'); ?>">
				<button type="submit" class="btn btn-primary clear-compare pull-right" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_REMOVE_ALL') ?>">
					<i class="icon-remove icon-lg" aria-hidden="true"></i> <span><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_REMOVE_ALL') ?></span>
				</button>
				<input type="hidden" name="component" value="com_ajax" />
				<input type="hidden" name="plugin" value="vpframework" />
				<input type="hidden" name="format" value="raw" />
				<input type="hidden" name="vpfmethod" value="clearCompare" />
				<input type="hidden" name="return" value="<?php echo base64_encode(JUri::current()) ?>" />
			</form>
		</div>
		<div class="row row-condensed">
			<?php foreach($this->cproducts as $product) : ?>
				<div class="<?php echo $class ?>">
					<div class="product compare-item-inner">
						<form name="comparisonItem" method="post" action="<?php echo JRoute::_('index.php?option=com_ajax&plugin=vpframework&format=raw'); ?>">
							<button type="submit" class="btn btn-transparent compare-remove" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_REMOVE') ?>">
								<i class="fa fa-times-circle-o" aria-hidden="true"></i>
								<span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_REMOVE') ?></span>
							</button>
							<input type="hidden" name="component" value="com_ajax" />
							<input type="hidden" name="plugin" value="vpframework" />
							<input type="hidden" name="format" value="raw" />
							<input type="hidden" name="vpfmethod" value="removeFromCompare" />
							<input type="hidden" name="product_id" value="<?php echo $product->virtuemart_product_id ?>" />
							<input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name) ?>" />
							<input type="hidden" name="return" value="<?php echo base64_encode(JUri::current()) ?>" />
						</form>
						<div class="product-name">
							<a href="<?php echo $product->link ?>" title="<?php echo $product->product_name ?>" class="hover-invert"><?php echo $product->product_name ?></a>
						</div>
						<?php if($this->show_rating && $params->get('show_rating_comp', 1)) : ?>
							<div class="product-rating">
								<?php echo shopFunctionsF::renderVmSubLayout('rating', array('showRating' => $this->show_rating, 'product' => $product)); ?>
							</div>
						<?php endif; ?>
						<?php if($params->get('show_sku_comp', 1)) : ?>
							<div class="product-sku">
								<span><?php echo JText::_('COM_VIRTUEMART_CART_SKU') ?>:&nbsp;</span><?php echo $product->product_sku ?>
							</div>
						<?php endif; ?>
						<div class="product-category">
							<?php if(!empty($product->virtuemart_category_id)) : ?>
								<span><?php echo JText::_('COM_VIRTUEMART_CATEGORY') ?>:&nbsp;</span>
								<a href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $product->virtuemart_category_id) ?>"><?php echo $product->category_name ?></a>
							<?php endif; ?>
						</div>
						<div class="product-image">
							<?php if(!empty($product->images[0])) : ?>
								<a href="<?php echo $product->link ?>" title="<?php echo $product->product_name ?>">
									<?php echo $product->images[0]->displayMediaThumb ('class="responsive-image"', false); ?>
								</a>
							<?php endif; ?>
						</div>
						<?php if(VmConfig::get('show_prices')) : ?>
							<div class="product-price">
								<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $currency)); ?>
							</div>
						<?php endif; ?>
						<?php if($params->get('show_sdesc_comp', 1)) : ?>
							<div class="product-s-desc">
								<?php echo $product->product_s_desc ?>
							</div>
						<?php endif; ?>
						<?php if($params->get('show_desc_comp', 1)) : ?>
							<div class="product-desc">
								<div class="property-title"><?php echo JText::_('COM_VIRTUEMART_PRODUCT_DESC_TITLE') ?></div>
								<?php echo $product->product_desc ?>
							</div>
						<?php endif; ?>
						<?php if($params->get('show_fields_comp', 1)) : ?>
							<div class="product-fields">
								<?php if(!empty($product->customfieldsSorted)) 
								{
									foreach($product->customfieldsSorted as $position => $customFields)
									{
										if($position != 'addtocart' && !empty($customFields))
										{
											$custom_title = null;
											foreach($customFields as $field)
											{
												if(!$field->is_hidden && !in_array($field->field_type, array('R', 'Z'))) { ?>
													<div class="product-field product-field-type-<?php echo $field->field_type ?>">
														<?php if(($field->custom_title != $custom_title) && $field->show_title) : ?>
															<?php 
															$titleClass = !empty($field->custom_tip) ? 'class="product-fields-title hasTooltip"' : 'class="product-fields-title"';
															$title = !empty($field->custom_tip) ? ' title="' . vmText::_($field->custom_tip) . '"' : '';
															?>
															<div class="property-title">
																<span <?php echo $titleClass . $title ?>><?php echo vmText::_($field->custom_title) ?></span>
															</div>
														<?php endif; ?>
														<?php if(!empty($field->display)) : ?>
															<div class="product-field-display">
																<?php echo $field->display; ?>
															</div>
														<?php endif; ?>
														<?php if(!empty($field->custom_desc)) : ?>
															<div class="product-field-desc"><?php echo vmText::_($field->custom_desc) ?></div> 
														<?php endif; ?>
													</div>
													<?php $custom_title = $field->custom_title; ?>
												<?php
												}
											}
										}
									}
								} ?>
							</div>
						<?php endif; ?>
						<?php if($params->get('show_availability_comp', 1)) : ?>
							<div class="product-availability">
								<?php if(VmConfig::get('display_stock', 1)) : ?>
									<div class="product-stock">
										<span class="<?php echo $product->stock->class ?> hasTooltip" title="<?php echo $product->stock->tip ?>"><?php echo $product->stock->text ?></span>
									</div>
								<?php endif; ?>
								<?php echo shopFunctionsF::renderVmSubLayout('stockhandle', array('product' => $product)); ?>
							</div>
						<?php endif; ?>
						<?php if($params->get('show_addtocart_comp', 1)) : ?>
							<div class="product-addtocart">
								<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product)); ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>
<?php echo vmJsApi::writeJS(); ?>