<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

$url = !empty($this->manufacturer->virtuemart_manufacturer_id) ?
       JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_manufacturer_id=' . $this->manufacturer->virtuemart_manufacturer_id, false) : 
       null;
?>
<section class="manufacturer-details-view">
	<div class="page-header">
		<h1><?php echo $this->manufacturer->mf_name; ?></h1>
	</div>
	<div class="manufactuer-details-cont">
		<div class="row">
			<?php if (!empty($this->manufacturerImage)) : ?>
				<div class="col-sm-4">
					<div class="manufacturer-image-cont">
						<?php echo $this->manufacturerImage; ?>
					</div>
				</div>
			<?php endif; ?>
			<div class="<?php echo !empty($this->manufacturerImage) ? 'col-sm-6' : 'col-xs-12'; ?>">
				<?php if(!empty($this->manufacturer->mf_email)) : ?>
					<div class="manufacturer-email-cont">
						<?php echo JHtml::_('email.cloak', $this->manufacturer->mf_email, true, $this->manufacturer->mf_email, false); ?>
					</div>
				<?php endif; ?>
				<?php if(!empty($this->manufacturer->mf_url)) : ?>
					<div class="manufacturer-url">
						<a target="_blank" href="<?php echo $this->manufacturer->mf_url ?>"><?php echo $this->manufacturer->mf_url ?></a>
					</div>
				<?php endif; ?>
				<?php if(!empty($this->manufacturer->mf_desc)) : ?>
					<div class="manufacturer-description-cont">
						<?php echo $this->manufacturer->mf_desc ?>
					</div>
				<?php endif; ?>
				<?php if(!empty($url)) : ?>
				<div class="manufacturer-product-link">
					<a target="_top" href="<?php echo $url; ?>" class="btn btn-base"><?php echo vmText::sprintf('COM_VIRTUEMART_PRODUCT_FROM_MF', $this->manufacturer->mf_name); ?></a>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>