<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');
?>
<?php if(empty($this->orderdetails)) : ?>

	<?php JFactory::getApplication()->input->set('view', 'user'); ?>
	<div class="order-list-login-form">
		<?php echo shopFunctionsF::getLoginForm(false, $this->trackingByOrderPass); ?>
	</div>
	<?php JFactory::getApplication()->input->set('view', 'orders'); ?>
	
<?php elseif($this->print) : ?>

	<div><img src="<?php echo JURI::root() . $this-> vendor->images[0]->file_url ?>"></div>
	<h2><?php  echo $this->vendor->vendor_store_name; ?></h2>
	<?php echo $this->vendor->vendor_name . (!empty($this->vendor->vendor_phone) ? ' - ' . $this->vendor->vendor_phone : ''); ?>
	<h1><?php echo vmText::_('COM_VIRTUEMART_ACC_ORDER_INFO'); ?></h1>
	<div class="add-space">
		<?php echo $this->loadTemplate('order'); ?>
	</div>
	<div class="add-space">
		<?php echo $this->loadTemplate('items'); ?>
	</div>
	<?php	echo $this->vendor->vendor_letter_footer_html; ?>
	
<?php else : ?>

	<div class="page-header">
		<h1><?php echo vmText::_('COM_VIRTUEMART_ACC_ORDER_INFO'); ?>
			<a href="#" data-iframe="modal" class="btn btn-nobg light-link" title="<?php echo vmText::_('COM_VIRTUEMART_PRINT') ?>" data-url="<?php echo JRoute::_($this->details_url . '&print=1') ?>">
				<i class="fa fa-print fa-2x"></i><span class="sr-only"><?php echo vmText::_('COM_VIRTUEMART_PRINT') ?></span>
			</a>
			<?php
			$this->orderdetails['details']['BT']->invoiceNumber = VmModel::getModel('orders')->getInvoiceNumber($this->orderdetails['details']['BT']->virtuemart_order_id);
			echo shopFunctionsF::getInvoiceDownloadButton($this->orderdetails['details']['BT']);
			?>
		</h1>
	</div>
	
	<?php if($this->order_list_link) : ?>
		<div class="add-space clearfix">
			<a href="<?php echo $this->order_list_link ?>" rel="nofollow" class="btn btn-default pull-right"><?php echo vmText::_('COM_VIRTUEMART_ORDERS_VIEW_DEFAULT_TITLE'); ?></a>
		</div>
	<?php endif; ?>

	<?php echo $this->loadTemplate('order'); ?>
	
	<div role="tabpanel">
		<ul class="nav nav-tabs" role="tablist">
			<li role="presentation" class="active"><a href="#items" aria-controls="items" role="tab" data-toggle="tab"><?php echo vmText::_('COM_VIRTUEMART_ORDER_ITEM') ?></a></li>
			<li role="presentation"><a href="#history" aria-controls="history" role="tab" data-toggle="tab"><?php echo vmText::_('COM_VIRTUEMART_ORDER_HISTORY') ?></a></li>
		</ul>
		<div class="tab-content">
			<div role="tabpanel" class="tab-pane fade in active" id="items"><?php echo $this->loadTemplate('items'); ?></div>
			<div role="tabpanel" class="tab-pane fade" id="history"><?php echo $this->loadTemplate('history'); ?></div>
		</div>
	</div>		

<?php endif; ?>






