<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$link     = 'index.php?option=com_virtuemart&view=productdetails&tmpl=component&virtuemart_product_id=' . $this->product->virtuemart_product_id;
$mailLink = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=recommend&virtuemart_product_id=' .
                      $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component');
?>
<?php if(VmConfig::get('show_emailfriend') || VmConfig::get('show_printicon') || VmConfig::get('pdf_icon')) : ?>
<div class="product-page-icons navbar-right hidden-xs">
	<div class="dropdown">
		<a id="vmIcons" class="light-link" data-target="#" href="#" data-toggle="dropdown" aria-haspopup="true" role="button" aria-expanded="false">
			<span class="fa fa-cog fa-lg"></span>
		</a>
		<ul class="dropdown-menu" role="menu" aria-labelledby="vmIcons">
			<?php if(VmConfig::get('pdf_icon')) : ?>
				<li class="">
						<a href="<?php echo JRoute::_($link . '&format=pdf') ?>" title="<?php echo vmText::_('COM_VIRTUEMART_PDF') ?>" target="_blank">
							<i class="fa fa-file-pdf-o"></i>&nbsp;&nbsp;<span><?php echo vmText::_('COM_VIRTUEMART_PDF') ?></span>
						</a>
				</li>
			<?php endif; ?>
			<?php if(VmConfig::get('show_printicon')) : ?>
				<li>
						<a href="#" data-iframe="modal" title="<?php echo vmText::_('COM_VIRTUEMART_PRINT') ?>" data-url="<?php echo JRoute::_($link . '&print=1') ?>">
							<i class="fa fa-print"></i>&nbsp;&nbsp;<span><?php echo vmText::_('COM_VIRTUEMART_PRINT') ?></span>
						</a>
				</li>
			<?php endif; ?>
			<?php if(VmConfig::get('show_emailfriend')) : ?>
				<li>
						<a href="#" data-iframe="modal" title="<?php echo vmText::_('COM_VIRTUEMART_EMAIL') ?>" data-modaltitle="<?php echo vmText::_('COM_VIRTUEMART_PRODUCT_RECOMMEND') ?>" data-url="<?php echo $mailLink ?>">
							<i class="fa fa-share-alt"></i>&nbsp;&nbsp;<span><?php echo vmText::_('COM_VIRTUEMART_EMAIL') ?></span>
						</a>
				</li>
			<?php endif; ?>
		</ul>
	</div>
</div>
<?php endif; ?>