<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

$app            = JFactory::getApplication();
$doc            = JFactory::getDocument();
$print          = $app->input->getInt('print', 0);
$template       = plgSystemVPFrameworkHelper::getTemplate();
$params         = $template->params;
$zoomEnabled    = $params->get('vpf_zoom_enabled', 1);
$lightboxItems  = array();
$js = "
jQuery(document).ready(function($) {
  $(document).on('vm.product.images.loaded', function(){
    $('.product-thumb-carousel').owlCarousel({
      itemsCustom: [[0, 1], [219, 2], [299, 3], [459, 4], [640, 5], [747, 3], [1259, 4]],
      responsiveRefreshRate: 50,
      autoPlay: 5000,
      theme: 'owl-thumbnail-carousel',
      navigation: true,
      pagination: false,
      slideSpeed: 200,
      paginationSpeed: 800,
      rewindSpeed: 600,
      stopOnHover: true,
      rewindNav: true,
      navigationText: false
    });
  });
  $(document).trigger('vm.product.images.loaded');
  $('body').on('updateVirtueMartProductDetail', function() {
    $(document).trigger('vm.product.images.loaded');
  });
});
";
vmJsApi::addJScript('productImageGallery', $js);
?>
<?php if(!empty($this->product->images)) : ?>
	<?php 
	$image = new VPFrameworkVMImage($this->product->images[0]); 
	$fullImage = $image->getFull($this->product->product_name);
	?>
	<figure class="product-image-gallery-cont">
		<?php if(!empty($this->product->images[0]) && !empty($this->product->images[0]->file_url)) : ?>
			<meta itemprop="image" content="<?php echo $template->getCleanImageURL($this->product->images[0]->file_url, true) ?>"/>
		<?php endif; ?>
		<div class="product-image-gallery-main-cont">
			<?php echo shopFunctionsF::renderVmSubLayout('tags', array('product' => $this->product)); ?>
			<?php if($print) : ?>
				<img src="<?php echo $fullImage['url'] ?>" alt="<?php echo $fullImage['alt'] ?>" id="vpf-simplegallery-main" class="responsive-image"/>
			<?php elseif($zoomEnabled) : ?>
				<a href="<?php echo $fullImage['url'] ?>" class="vpf-zoom" id="product-image-gallery" rel="adjustX: 10, adjustY:0">
					<img src="<?php echo $fullImage['url'] ?>" alt="<?php echo $fullImage['alt'] ?>" class="responsive-image"/>
				</a>
			<?php else : ?>
				<a href="#"><img src="<?php echo $fullImage['url'] ?>" alt="<?php echo $fullImage['alt'] ?>" id="vpf-simplegallery-main" class="responsive-image"/></a>
			<?php endif; ?>
			<?php $lightboxItems[] = '<a href="' . $fullImage['url'] . '" title="' . htmlspecialchars($this->product->product_name) . '" class="active" data-key="0" data-imagelightbox="f"></a>'; ?>
		</div>
		
		<?php $class = $zoomEnabled ? 'vpf-zoom-gallery' : 'vpf-simplegallery-item'; ?>
		<?php if(count($this->product->images) > 1) : ?>
			<div class="product-thumb-carousel owl-carousel owl-thumbnail-carousel">
				<?php foreach($this->product->images as $key => $image) : ?>
					<?php 
					$image = new VPFrameworkVMImage($image); 
					$fullImage = $image->getFull($this->product->product_name);
					$thumbImage = $image->getThumb($this->product->product_name);
					?>
					<div class="image-thumb<?php echo ($key == 0) ? ' active' : ''; ?>">
						<?php if($print) : ?>
							<img src="<?php echo $thumbImage['url'] ?>" alt="<?php echo $thumbImage['alt'] ?>" />
						<?php else : ?>
							<a href="<?php echo $fullImage['url'] ?>" class="<?php echo $class ?>" data-key="<?php echo $key ?>" data-sync="#product-light-box-images" <?php echo $zoomEnabled ? 'rel="useZoom: \'product-image-gallery\', smallImage: \'' . htmlspecialchars($fullImage['url']) . '\'"' : 'data-main="#vpf-simplegallery-main" data-cont=".product-thumb-carousel"' ?>>
								<img src="<?php echo $thumbImage['url'] ?>" alt="<?php echo $thumbImage['alt'] ?>" />
							</a>
						<?php endif; ?>
					</div>
					<?php if($key > 0)
					{
						$lightboxItems[] = '<a href="' . $fullImage['url'] . '" title="' . htmlspecialchars($this->product->product_name) . '" data-key="' . $key . '" data-imagelightbox="f"></a>';
					} ?>
				<?php endforeach; ?>
			</div>
		<?php elseif(count($this->product->images) == 1) : ?>
			<div class="hide">
				<?php foreach($this->product->images as $key => $image) : ?>
					<?php 
					$image = new VPFrameworkVMImage($image); 
					$fullImage = $image->getFull($this->product->product_name);
					$thumbImage = $image->getThumb($this->product->product_name);
					?>
					<a href="<?php echo $fullImage['url'] ?>" class="<?php echo $class ?>" data-key="<?php echo $key ?>" data-sync="#product-light-box-images" <?php echo $zoomEnabled ? 'rel="useZoom: \'product-image-gallery\', smallImage: \'' . htmlspecialchars($fullImage['url']) . '\'"' : 'data-main="#vpf-simplegallery-main" data-cont=".product-thumb-carousel"' ?>>
						<img src="<?php echo $thumbImage['url'] ?>" alt="<?php echo $thumbImage['alt'] ?>" />
					</a>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>
		<?php if(!$print) : ?>
			<div id="product-light-box-images">
				<?php echo implode($lightboxItems) ?>
			</div>
		<?php endif; ?>
		
	</figure>
<?php endif; ?>
