<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined ( '_JEXEC' ) or die ( 'Restricted access' );

$doc = JFactory::getDocument();
$app = JFactory::getApplication();
$print = $app->input->getInt('print', 0);
$template = plgSystemVPFrameworkHelper::getTemplate();
$params = $template->params;

$js = "
jQuery(document).ready(function($) {
  $(document).on('vm.product.related.loaded', function(){
    $('.related-products-carousel').owlCarousel({
      itemsCustom: [[0, 1], [219, 1], [299, 1], [459, 2], [640, 3], [747, 4], [1259, 4]],
      responsiveRefreshRate: 50,
      autoPlay: 5000,
      theme: 'owl-nav-side',
      navigation: false,
      pagination: true,
      slideSpeed: 200,
      paginationSpeed: 800,
      rewindSpeed: 600,
      stopOnHover: true,
      rewindNav: true,
      navigationText: false,
      autoHeight: false,
    });
  });
  $(document).trigger('vm.product.related.loaded');
  $('body').on('updateVirtueMartProductDetail', function() {
    $(document).trigger('vm.product.related.loaded');
  });
});
";
vmJsApi::addJScript('relatedProductsGallery', $js);
?>
<?php if(isset($this->related_products) && !empty($this->related_products)) : ?>
	<?php
	$heading = null;
	if(isset($this->related_products[0]))
	{
		$firstField =  $this->related_products[0];
		$titleClass = !empty($firstField->custom_tip) ? ' class="mod-header-title hasTooltip"' : ' class="mod-header-title"';
		$title = !empty($firstField->custom_tip) ? $titleClass . ' title="' . vmText::_($firstField->custom_tip) . '"' : $titleClass;
		$heading = vmText::_($firstField->custom_title);
	} ?>
	<div class="related-products-cont mod-big-header">
		<?php if(!empty($heading)) : ?>
			<h3 class="related-product-header mod-header"><span<?php echo $title ?>><?php echo $heading ?></span></h3>
		<?php endif; ?>
		<div class="related-products related-products-carousel owl-carousel owl-nav-side">
			<?php foreach($this->related_products as $field) : ?>
				<?php if(!empty($field->display)) : ?> 
					<div class="related-product">
						<?php echo $field->display; ?>
					</div>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>