<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$_template       = plgSystemVPFrameworkHelper::getTemplate();
$params          = $_template->params;
$product         = $viewData['product'];
$isList          = isset($viewData['isList']) ? $viewData['isList'] : false;
$listMode        = isset($viewData['listMode']) ? $viewData['listMode'] : '';
$showDetailsLink = isset($viewData['showDetailsLink']) ? $viewData['showDetailsLink'] : false;
$askquestion_url = !empty($viewData['askquestion_url']) ? $viewData['askquestion_url'] : null;
$customClass     = 'product-cart-variants';
?>
<div class="addtocart-area">
	<form method="post" class="product js-recalculate" action="<?php echo JRoute::_('index.php', false); ?>" target="_parent">
		<?php if(!$isList) : ?>
			<?php echo shopFunctionsF::renderVmSubLayout('customfields', array('product' => $product, 'position' => 'addtocart', 'class' => $customClass, 'isList' => $isList)); ?>
		<?php endif; ?>
		<?php echo shopFunctionsF::renderVmSubLayout('addtocartbar', array('product' => $product, 'isList' => $isList, 'listMode' => $listMode, 'showDetailsLink' => $showDetailsLink, 'askquestion_url' => $askquestion_url)); ?>
		<input type="hidden" name="option" value="com_virtuemart" />
		<input type="hidden" name="view" value="cart" />
		<input type="hidden" name="virtuemart_product_id[]" value="<?php echo $product->virtuemart_product_id ?>" />
		<input type="hidden" class="pname" value="<?php echo $product->product_name ?>" />
		<?php if($itemId = vRequest::getInt('Itemid', 0)) : ?>
			<input type="hidden" name="Itemid" value="<?php echo $itemId ?>" />
		<?php endif; ?>
	</form>
</div>