<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::_('behavior.formvalidator');

$this->show       = !isset($this->show) ? true : $this->show;
$this->from_cart  = !isset($this->from_cart) ? true : $this->from_cart;
$this->order      = !isset($this->order) ? true : $this->order;
$this->useSSL     = !isset($this->useSSL) ? false : $this->useSSL;
$user             = JFactory::getUser();
$app              = JFactory::getApplication();
$input            = $app->input;
$option           = strtolower($input->getCmd('option', ''));
$view             = strtolower($input->getCmd('view', ''));
$isCartPage       = ($option == 'com_virtuemart' && in_array($view, array('cart', 'pluginresponse', 'vmplg')));

if($this->from_cart)
{
	$url = 'index.php?option=com_virtuemart&view=cart';
	
	if($layout = $input->getCmd('layout', null))
	{
		$url .= '&layout=' . $layout;
	}
}
else
{
	$url = !empty($this->url) ? $this->url : vmURI::getCleanUrl();
}

$srcUrl = $url;

if ((version_compare(JVERSION, '4.0.0', 'ge')))
{
	$srcUrl = JUri::root();
}

if($this->show && $user->guest) 
{
	if(JPluginHelper::isEnabled('authentication', 'openid'))
	{
		JHtml::_('behavior.modal');
		
		$lang = JFactory::getLanguage();
		$lang->load('plg_authentication_openid', JPATH_ADMINISTRATOR);
		
		$langScript = '
		//<![CDATA[
		'.'var JLanguage = {};' .
		                ' JLanguage.WHAT_IS_OPENID = \'' . vmText::_('WHAT_IS_OPENID') . '\';' .
		                ' JLanguage.LOGIN_WITH_OPENID = \'' . vmText::_('LOGIN_WITH_OPENID') . '\';' .
		                ' JLanguage.NORMAL_LOGIN = \'' . vmText::_('NORMAL_LOGIN') . '\';' .
		                ' var comlogin = 1;
		//]]>
		                ';
		vmJsApi::addJScript('login_openid', $langScript);
		JHtml::_('script', 'openid.js');
	}

	$html = '';
	JPluginHelper::importPlugin('vmpayment');
	
	if (version_compare(JVERSION, '4.0.0', 'ge'))
	{
		$app->triggerEvent('plgVmDisplayLogin', array($this, &$html, $this->from_cart));
	}
	else
	{
		$dispatcher = JDispatcher::getInstance();
		$returnValues = $dispatcher->trigger('plgVmDisplayLogin', array($this, &$html, $this->from_cart));
	}

	if(is_array($html))
	{
		foreach($html as $login)
		{
			echo $login . '<br/>';
		}
	}
	else 
	{
		echo $html;
	} 
	// end plugins section ?>

	<?php
	// anonymous order section
	if($this->order) : ?>
		<div class="order-view">
			<h2 class="section-header"><?php echo vmText::_('COM_VIRTUEMART_ORDER_ANONYMOUS') ?></h2>
			<form action="<?php echo JRoute::_('index.php', 1, $this->useSSL); ?>" method="post" class="form-inline" role="form">
				<div class="form-group" id="com-form-order-number">
					<label class="control-label" for="order_number"><?php echo vmText::_('COM_VIRTUEMART_ORDER_NUMBER') ?></label>
					<input type="text" class="form-control" name="order_number" id="order_number" placeholder="<?php echo vmText::_('COM_VIRTUEMART_ORDER_NUMBER') ?>" value=""/>
				</div>
				<div class="form-group" id="com-form-order-pass">
					<label class="control-label" for="order_pass"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PASS') ?></label>
					<input type="text" class="form-control" name="order_pass" id="order_pass" placeholder="<?php echo vmText::_('COM_VIRTUEMART_ORDER_PASS') ?>" value="p_"/>
				</div>
				<div class="form-group" id="com-form-order-submit">
					<button type="submit" class="btn btn-default" title="<?php echo vmText::_('COM_VIRTUEMART_ORDER_BUTTON_VIEW') ?>"><?php echo vmText::_('COM_VIRTUEMART_ORDER_BUTTON_VIEW') ?></button>
				</div>
				<input type="hidden" name="option" value="com_virtuemart" />
				<input type="hidden" name="view" value="orders" />
				<input type="hidden" name="layout" value="details" />
				<input type="hidden" name="return" value="" />
			</form>
		</div>
	<?php endif; 
	// end anonymous order section
	?>
	<?php if($isCartPage) : ?>
		<h2 class="section-header"><?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?></h2>
		<form id="com-form-login" action="<?php echo JRoute::_($srcUrl, true, $this->useSSL); ?>" method="post" class="form-validate form-inline">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon" id="username-label"><i class="fa fa-user"></i></span>
					<input type="text" class="form-control" name="username" id="username" placeholder="<?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?>" value="" required="true" aria-describedby="username-label"/>
				</div>
			</div>
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon" id="password-label"><i class="fa fa-lock"></i></span>
					<input type="password" class="form-control" name="password" id="password" placeholder="<?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?>" value="" required="true" aria-describedby="password-label"/>
				</div>
			</div>
			<button class="btn btn-default" type="submit"><?php echo vmText::_('COM_VIRTUEMART_LOGIN') ?></button>
			<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
				<div class="checkbox">
					<label for="remember" class="checkbox-inline">
						<input type="checkbox" id="remember" name="remember" value="yes" />
						&nbsp;<?php echo vmText::_('JGLOBAL_REMEMBER_ME') ?>
					</label>
				</div>
			<?php endif; ?>
			<input type="hidden" name="task" value="user.login" />
			<input type="hidden" name="option" value="com_users" />
			<input type="hidden" name="return" value="<?php echo base64_encode($url) ?>" />
			<?php echo JHtml::_('form.token'); ?>
		</form>
		<div class="login-page-system-links">
			<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_USERNAME'); ?></a>
			<?php if($input->getCmd('view') == 'cart') : ?>
				<span>&nbsp;/&nbsp;</span>
			<?php else : ?>
				<span>&nbsp;</span>
			<?php endif; ?>
			<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_PASSWORD'); ?></a>
		</div>
	<?php else : ?>
		<div class="row">
			<div class="col-sm-offset-3 col-sm-9">
				<h2 class="section-header"><?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?></h2>
			</div>
		</div>
		<form id="com-form-login" action="<?php echo JRoute::_($srcUrl, true, $this->useSSL); ?>" method="post" class="form-validate <?php echo $input->getCmd('view') == 'user' ? 'form-horizontal' : 'form-inline'; ?>">
			<div class="form-group">
				<label class="control-label col-sm-3" for="username"><?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?></label>
				<div class="col-sm-9">
					<input type="text" class="form-control" name="username" id="username" placeholder="<?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?>" value="" required="true"/>
				</div>
			</div>
			<div class="form-group">
				<label class="control-label col-sm-3" for="password"><?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?></label>
				<div class="col-sm-9">
					<input type="password" class="form-control" name="password" id="password" placeholder="<?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?>" value="" required="true"/>
				</div>
			</div>
			<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
			<div class="form-group">
				<div class="col-sm-offset-3 col-sm-9">
					<div class="checkbox">
						<label for="remember" class="checkbox-inline">
							<input type="checkbox" id="remember" name="remember" value="yes" /><?php echo vmText::_('JGLOBAL_REMEMBER_ME') ?>
						</label>
					</div>
				</div>
			</div>
			<?php endif; ?>
			<div class="form-group">
				<div class="col-sm-offset-3 col-sm-9">
					<button class="btn btn-base btn-lg" type="submit"><?php echo vmText::_('COM_VIRTUEMART_LOGIN') ?></button>
				</div>
			</div>
			<div class="form-group">
				<div class="col-sm-offset-3 col-sm-9">
					<ul class="list-inline">
						<li><a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_USERNAME'); ?></a></li>
						<li><a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_PASSWORD'); ?></a></li>
					</ul>
				</div>
			</div>
			<input type="hidden" name="task" value="user.login" />
			<input type="hidden" name="option" value="com_users" />
			<input type="hidden" name="return" value="<?php echo base64_encode($url) ?>" />
			<?php echo JHtml::_('form.token'); ?>
		</form>
		<hr />
	<?php endif; ?>
<?php } elseif(!$user->guest) { ?>
	<form action="<?php echo JRoute::_($srcUrl, true, $this->useSSL); ?>" method="post" id="form-logout" class="form-inline" role="form">
		<div class="form-group">
			<label class="sr-only"><?php echo vmText::sprintf( 'COM_VIRTUEMART_HINAME', $user->name ); ?></label>
			<p class="form-control-static"><?php echo vmText::sprintf( 'COM_VIRTUEMART_HINAME', $user->name ); ?></p>
		</div>
		<div class="form-group">
			<span class="hidden-xs">&nbsp;</span>
			<button type="submit" class="btn btn-default" title="<?php echo vmText::_( 'COM_VIRTUEMART_BUTTON_LOGOUT'); ?>"><?php echo vmText::_( 'COM_VIRTUEMART_BUTTON_LOGOUT'); ?></button>
		</div>	
		<input type="hidden" name="option" value="com_users" />
		<input type="hidden" name="task" value="user.logout" />
		<input type="hidden" name="return" value="<?php echo base64_encode($url) ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
<?php } ?>