<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

$closeFieldset = false;
$hiddenFields = '';
$i = 0;

foreach($this->userFields['fields'] as $field) 
{
	if($field['type'] == 'delimiter') 
	{
		if($closeFieldset)
		{
			echo '</fieldset>' . "\n";
			$closeFieldset = false;
		}
		
		echo '<fieldset>' . "\n";
		echo '<legend>' . $field['title'] . '</legend>' . "\n";
		$closeFieldset = true;
	}
	elseif($field['hidden'])
	{
		$hiddenFields .= $field['formcode'] . "\n";
	}
	else
	{
		if($i == 0)
		{
			echo '<fieldset>';
			$closeFieldset = true;
		}
		$title = empty($field['description']) ? $field['title'] : addslashes('<strong>' . $field['title'] . '</strong><br/>' . $field['description']) ;
		$id = $field['name'] . '_field'; ?>
		<div class="form-group">
			<?php if($field['name'] == 'agreed') : ?>
				<div class="col-sm-offset-3 col-sm-9">
					<div class="checkbox">
						<label class="control-label" for="<?php echo $id ?>">
							<?php echo $field['formcode']; ?>
							<span class="hasTooltip" title="<?php echo $title ?>"><?php echo $field['title'] . ($field['required'] ? ' <span class="asterisk">*</span>' : '') ?></span>
						</label>
					</div>
				</div>
			<?php else : ?>
				<label class="control-label col-sm-3 <?php echo $field['name'] ?>" for="<?php echo $id ?>">
					<span class="hasTooltip" title="<?php echo $title ?>"><?php echo $field['title'] . ($field['required'] ? ' <span class="asterisk">*</span>' : '') ?></span>
				</label>
				<div class="col-sm-9">
					<?php echo $field['formcode'] ?>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}
	$i++;
}

if($closeFieldset)
{
	echo '</fieldset>' . "\n";
}

echo $hiddenFields; 
?>