<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('JPATH_BASE') or die;
?>
<?php if (version_compare(JVERSION, '4.0.0', 'ge')) : ?>
	<dd class="category-name">
		<?php $title = $this->escape($displayData['item']->category_title); ?>
		<?php if ($displayData['params']->get('link_category') && !empty($displayData['item']->catid)) : ?>
			<?php $url = '<a href="' . JRoute::_(Joomla\Component\Content\Site\Helper\RouteHelper::getCategoryRoute($displayData['item']->catid, $displayData['item']->category_language)) . '" itemprop="genre">' . $title . '</a>'; ?>
			<?php echo JText::sprintf('COM_CONTENT_CATEGORY', $url); ?>
		<?php else : ?>
			<?php echo JText::sprintf('COM_CONTENT_CATEGORY', '<span itemprop="genre">' . $title . '</span>'); ?>
		<?php endif; ?>
	</dd>
<?php else : ?>
	<dd class="category-name">
		<?php $title = $this->escape($displayData['item']->category_title); ?>
		<?php if ($displayData['params']->get('link_category') && $displayData['item']->catslug) : ?>
			<?php $url = '<a class="hover-invert" href="' . JRoute::_(ContentHelperRoute::getCategoryRoute($displayData['item']->catslug)) . '" itemprop="genre">' . $title . '</a>'; ?>
			<?php echo JText::sprintf('COM_CONTENT_CATEGORY', $url); ?>
		<?php else : ?>
			<?php echo JText::sprintf('COM_CONTENT_CATEGORY', '<span itemprop="genre">' . $title . '</span>'); ?>
		<?php endif; ?>
	</dd>
<?php endif; ?>
