<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

if (version_compare(JVERSION, '4.0.0', 'ge'))
{
	JLoader::registerAlias('modFinderHelper', '\\Joomla\\Module\\Finder\\Site\\Helper\\FinderHelper');
}

JHtml::addIncludePath(JPATH_SITE . '/components/com_finder/helpers/html');

JHtml::_('jquery.framework');
JHtml::_('bootstrap.tooltip');

// Load the smart search component language file.
$lang = JFactory::getLanguage();
$lang->load('com_finder', JPATH_SITE);

$show_advanced = $params->get('show_advanced');
$suffix    = $params->get('moduleclass_sfx');
$output    = '<input type="text" name="q" id="mod-finder-searchword" class="search-query form-control input-lg' . ($show_advanced ? ' advanced-query' : '') . '" size="' .
             $params->get('field_size', 20) . '" value="' . htmlspecialchars(JFactory::getApplication()->input->get('q', '', 'string')) . '" />';
$groupOpen = false;

if ($params->get('show_button'))
{
	$button = '<button class="btn btn-default hasTooltip ' . $suffix . ' finder btn-lg' . $suffix . '" type="submit" title="' . JText::_('MOD_FINDER_SEARCH_BUTTON') . '"><i class="fa fa-search"></i></button>';

	switch ($params->get('button_pos', 'left'))
	{
		case 'top' :
			$output = $button . '<br />' . $output;
			break;

		case 'bottom' :
			$output .= '<br />' . $button;
			break;

		case 'right' :
			$output .= '<div class="input-group-btn">' . $button;
			if(!$params->get('show_advanced'))
			{
				$output .= '</div>';
			}
			$groupOpen = true;
			break;

		case 'left' :
		default :
			$button = '<div class="input-group-btn">' . $button . '</div>';
			$output = $button . $output;
			break;
	}
}

if ($show_advanced == 2)
{
	$advancedSearchButton = '<a class="btn btn-default" href="' . JRoute::_($route) . '">' . JText::_('COM_FINDER_ADVANCED_SEARCH') . '</a>';
	if(!$groupOpen)
	{
		$output .= '<div class="input-group-btn">';
	}
	$output .= $advancedSearchButton;
	$output .= '</div>';
}
elseif ($show_advanced == 1)
{
	$advancedSearchButton = '<button type="button" id="mod-advanced-search" class="btn btn-default btn-lg dropdown-toggle" data-toggle="dropdown" aria-expanded="false">' . JText::_('COM_FINDER_ADVANCED_SEARCH') . ' <span class="caret"></span></button>';
	$advancedSearchButton .= '<div class="dropdown-menu dropdown-menu-right" aria-labelledby="mod-advanced-search">';
	$advancedSearchButton .= '<div id="mod-finder-advanced">';
	$advancedSearchButton .= JHtml::_('filter.select', $query, $params);
	$advancedSearchButton .= '</div>';
	$advancedSearchButton .= '</div>';
	if(!$groupOpen)
	{
		$output .= '<div class="input-group-btn">';
	}
	$output .= $advancedSearchButton;
	$output .= '</div>';
}

$output = '<div class="input-group">' . $output . '</div>';

if ($params->get('show_label', 1))
{
	$labelClass = $params->get('label_pos', 'left') == 'left' || $params->get('label_pos', 'left') == 'right' ? 'col-sm-2 control-label ' : '';
	$label = '<label for="mod-finder-searchword" class="' . $labelClass . ' finder' . $suffix . '">' . $params->get('alt_label', JText::_('JSEARCH_FILTER_SUBMIT')) . '</label>';

	switch ($params->get('label_pos', 'left'))
	{
		case 'top' :
			$output = $label . '<br />' . $output;
			break;

		case 'bottom' :
			$output .= '<br />' . $label;
			break;

		case 'right' :
			$output = '<div class="col-sm-10">' . $output . '</div>';
			$output .= $label;
			$output = '<div class="form-group">' . $output . '</div>';
			break;

		case 'left' :
		default :
			$output = '<div class="col-sm-10">' . $output . '</div>';
			$output = '<div class="form-group">' . $label . $output . '</div>';
			break;
	}
}

JHtml::stylesheet('com_finder/finder.css', false, true, false);

$script = "
jQuery(document).ready(function() {
	var value, searchword = jQuery('#mod-finder-searchword');

		// Set the input value if not already set.
		if (!searchword.val())
		{
			searchword.val('" . JText::_('MOD_FINDER_SEARCH_VALUE', true) . "');
		}

		// Get the current value.
		value = searchword.val();

		// If the current value equals the default value, clear it.
		searchword.on('focus', function()
		{	var el = jQuery(this);
			if (el.val() === '" . JText::_('MOD_FINDER_SEARCH_VALUE', true) . "')
			{
				el.val('');
			}
		});

		// If the current value is empty, set the previous value.
		searchword.on('blur', function()
		{	var el = jQuery(this);
			if (!el.val())
			{
				el.val(value);
			}
		});

		jQuery('#mod-finder-searchform').on('submit', function(e){
			e.stopPropagation();
			var advanced = jQuery('#mod-finder-advanced');
			// Disable select boxes with no value selected.
			if ( advanced.length)
			{
				advanced.find('select').each(function(index, el) {
					var el = jQuery(el);
					if(!el.val()){
						el.attr('disabled', 'disabled');
					}
				});
			}
		});";
/*
 * This segment of code sets up the autocompleter.
 */
if ($params->get('show_autosuggest', 1))
{
	JHtml::_('script', 'media/jui/js/jquery.autocomplete.min.js', false, false, false, false, true);

	$script .= "
	var suggest = jQuery('#mod-finder-searchword').autocomplete({
		serviceUrl: '" . JRoute::_('index.php?option=com_finder&task=suggestions.suggest&format=json&tmpl=component', false) . "',
		paramName: 'q',
		minChars: 1,
		maxHeight: 400,
		width: 300,
		zIndex: 9999,
		deferRequestBy: 500
	});";
}

$script .= "});";

JFactory::getDocument()->addScriptDeclaration($script);
?>
<form id="mod-finder-searchform" action="<?php echo JRoute::_($route); ?>" method="get" class="form-horizontal">
	<div class="finder<?php echo $suffix; ?>">
		<?php echo $output; ?>
		<?php echo modFinderHelper::getGetFields($route, (int) $params->get('set_itemid')); ?>
	</div>
</form>