<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$inputClass = !empty($module->position) && $module->position == 'search' ? 'form-control input-lg search-query' : 'form-control search-query';
$btnClass   = !empty($module->position) && $module->position == 'search' ? 'btn btn-invert btn-lg search-button' : 'btn btn-invert search-button';
?>
<div class="search<?php echo $moduleclass_sfx ?>">
	<form action="<?php echo JRoute::_('index.php');?>" method="post" data-searchform>
		<?php
			$output = '<label for="mod-search-searchword" class="sr-only">' . $label . '</label> ';
			$output .= '<input name="searchword" id="mod-search-searchword" maxlength="' . $maxlength . '"  class="' . $inputClass . '" type="text" size="' . $width . '" value="" placeholder="' . $text . '" />';

			if ($button) :
				if ($imagebutton) :
					$btn_output = '<input type="image" value="' . $button_text . '" class="btn btn-transparent" src="' . $img . '" onclick="this.form.searchword.focus();"/>';
				else :
					$btn_output = '<button type="submit" class="' . $btnClass . '" title="' . $button_text . '" onclick="this.form.searchword.focus();"><i class="fa fa-search"></i><span class="sr-only">' . $button_text . '</span></button>';
				endif;

				switch ($button_pos) :
					case 'top' :
						$output = $btn_output . '<br />' . $output;
						break;

					case 'bottom' :
						$output .= '<br />' . $btn_output;
						break;

					case 'right' :
						$btn_output = '<div class="input-group-btn">' . $btn_output . '</div>';
						$output = $output . $btn_output;
						break;

					case 'left' :
					default :
						$btn_output = '<div class="input-group-btn">' . $btn_output . '</div>';
						$output = $btn_output . $output;
						break;
				endswitch;

			endif;
			
			if($button)
			{
				$output = '<div class="input-group">' . $output . '</div>';
			}
			
			echo $output;
		?>
		<input type="hidden" name="task" value="search"/>
		<input type="hidden" name="option" value="com_search"/>
		<input type="hidden" name="Itemid" value="<?php echo $mitemid; ?>"/>
	</form>
</div>
